/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.IncompatibleTransitionException;
import automata.Note;
import automata.State;
import automata.Transition;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.mealy.MooreMachine;
import automata.turing.TuringMachine;
import gui.action.OpenAction;
import gui.environment.EnvironmentFrame;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class Automaton
implements Serializable,
Cloneable {
    private String fileName = "";
    private EnvironmentFrame myEnvFrame = null;
    private Set states;
    private State[] cachedStates = null;
    private Transition[] cachedTransitions = null;
    private State[] cachedFinalStates = null;
    private Set finalStates;
    private State initialState = null;
    private Set transitions;
    private HashMap transitionFromStateMap = new HashMap();
    private HashMap transitionToStateMap = new HashMap();
    private HashMap transitionArrayFromStateMap = new HashMap();
    private HashMap transitionArrayToStateMap = new HashMap();
    private HashMap blockMap = new HashMap();
    private ArrayList myNotes = new ArrayList();
    private transient HashSet transitionListeners = new HashSet();
    private transient HashSet stateListeners = new HashSet();
    static /* synthetic */ Class class$0;

    public Automaton() {
        this.states = new HashSet();
        this.transitions = new HashSet();
        this.finalStates = new HashSet();
    }

    public Object clone() {
        State state;
        Automaton a;
        try {
            a = this instanceof TuringMachine ? new TuringMachine(((TuringMachine)this).tapes()) : (Automaton)this.getClass().newInstance();
        }
        catch (Throwable e) {
            System.err.println("Warning: clone of automaton failed!");
            return null;
        }
        a.setEnvironmentFrame(this.getEnvironmentFrame());
        HashMap<State, State> map = new HashMap<State, State>();
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            state = (State)it.next();
            State nstate = new State(state.getID(), new Point(state.getPoint()), a);
            this.copyRelevantDataForBlocks(nstate, state, a);
            nstate.setLabel(state.getLabel());
            nstate.setName(state.getName());
            map.put(state, nstate);
            a.addState(nstate);
            if (!(this instanceof MooreMachine)) continue;
            MooreMachine m = (MooreMachine)a;
            m.setOutput(nstate, ((MooreMachine)this).getOutput(state));
        }
        it = this.finalStates.iterator();
        while (it.hasNext()) {
            state = (State)it.next();
            a.addFinalState((State)map.get(state));
        }
        a.setInitialState((State)map.get(this.getInitialState()));
        it = this.states.iterator();
        while (it.hasNext()) {
            state = (State)it.next();
            Transition[] ts = this.getTransitionsFromState(state);
            State from = (State)map.get(state);
            int i = 0;
            while (i < ts.length) {
                State to = (State)map.get(ts[i].getToState());
                a.addTransition(ts[i].copy(from, to));
                ++i;
            }
        }
        int k = 0;
        while (k < this.getNotes().size()) {
            Note curNote = (Note)this.getNotes().get(k);
            a.addNote(new Note(curNote.getAutoPoint(), curNote.getText()));
            ++k;
        }
        return a;
    }

    private void copyRelevantDataForBlocks(State state, State old, Automaton newAuto) {
        state.setParentBlock(old.getParentBlock());
        String name = old.getInternalName();
        if (name == null) {
            return;
        }
        state.setInternalName(name);
        this.putBlockContentsInAutomaton(state, (Automaton)this.getBlockMap().get(name), name, newAuto);
    }

    public Transition[] getTransitionsFromState(State from) {
        Transition[] toReturn = (Transition[])this.transitionArrayFromStateMap.get(from);
        if (toReturn == null) {
            List list = (List)this.transitionFromStateMap.get(from);
            toReturn = list.toArray(new Transition[0]);
            this.transitionArrayFromStateMap.put(from, toReturn);
        }
        return toReturn;
    }

    public Transition[] getTransitionsToState(State to) {
        Transition[] toReturn = (Transition[])this.transitionArrayToStateMap.get(to);
        if (toReturn == null) {
            List list = (List)this.transitionToStateMap.get(to);
            toReturn = list.toArray(new Transition[0]);
            this.transitionArrayToStateMap.put(to, toReturn);
        }
        return toReturn;
    }

    public Transition[] getTransitionsFromStateToState(State from, State to) {
        Transition[] t = this.getTransitionsFromState(from);
        ArrayList<Transition> list = new ArrayList<Transition>();
        int i = 0;
        while (i < t.length) {
            if (t[i].getToState() == to) {
                list.add(t[i]);
            }
            ++i;
        }
        return list.toArray(new Transition[0]);
    }

    public Transition[] getTransitions() {
        if (this.cachedTransitions == null) {
            this.cachedTransitions = this.transitions.toArray(new Transition[0]);
        }
        return this.cachedTransitions;
    }

    public void addTransition(Transition trans) {
        if (!this.getTransitionClass().isInstance(trans) || trans == null) {
            throw new IncompatibleTransitionException();
        }
        if (this.transitions.contains(trans)) {
            return;
        }
        if (trans.getToState() == null || trans.getFromState() == null) {
            return;
        }
        this.transitions.add(trans);
        if (this.transitionFromStateMap == null) {
            this.transitionFromStateMap = new HashMap();
        }
        List list = (List)this.transitionFromStateMap.get(trans.getFromState());
        list.add(trans);
        if (this.transitionToStateMap == null) {
            this.transitionToStateMap = new HashMap();
        }
        list = (List)this.transitionToStateMap.get(trans.getToState());
        list.add(trans);
        this.transitionArrayFromStateMap.remove(trans.getFromState());
        this.transitionArrayToStateMap.remove(trans.getToState());
        this.cachedTransitions = null;
        this.distributeTransitionEvent(new AutomataTransitionEvent(this, trans, true, false));
    }

    public void replaceTransition(Transition oldTrans, Transition newTrans) {
        if (!this.getTransitionClass().isInstance(newTrans)) {
            throw new IncompatibleTransitionException();
        }
        if (oldTrans.equals(newTrans)) {
            return;
        }
        if (this.transitions.contains(newTrans)) {
            this.removeTransition(oldTrans);
            return;
        }
        if (!this.transitions.remove(oldTrans)) {
            throw new IllegalArgumentException("Replacing transition that not already in the automaton!");
        }
        this.transitions.add(newTrans);
        List list = (List)this.transitionFromStateMap.get(oldTrans.getFromState());
        list.set(list.indexOf(oldTrans), newTrans);
        list = (List)this.transitionToStateMap.get(oldTrans.getToState());
        list.set(list.indexOf(oldTrans), newTrans);
        this.transitionArrayFromStateMap.remove(oldTrans.getFromState());
        this.transitionArrayToStateMap.remove(oldTrans.getToState());
        this.cachedTransitions = null;
        this.distributeTransitionEvent(new AutomataTransitionEvent(this, newTrans, true, false));
    }

    public void removeTransition(Transition trans) {
        this.transitions.remove(trans);
        List l = (List)this.transitionFromStateMap.get(trans.getFromState());
        l.remove(trans);
        l = (List)this.transitionToStateMap.get(trans.getToState());
        l.remove(trans);
        this.transitionArrayFromStateMap.remove(trans.getFromState());
        this.transitionArrayToStateMap.remove(trans.getToState());
        this.cachedTransitions = null;
        this.distributeTransitionEvent(new AutomataTransitionEvent(this, trans, false, false));
    }

    public final State createBlock(Point point) {
        int i = 0;
        while (this.getStateWithID(i) != null) {
            ++i;
        }
        OpenAction read = new OpenAction();
        OpenAction.setOpenOrRead(true);
        JButton button = new JButton(read);
        button.doClick();
        OpenAction.setOpenOrRead(false);
        return this.getAutomatonFromFile(i, point);
    }

    private State getAutomatonFromFile(int i, Point point) {
        State block = new State(i, point, this);
        Serializable serial = OpenAction.getLastObjectOpened();
        File lastFile = OpenAction.getLastFileOpened();
        if (lastFile == null || !OpenAction.isOpened()) {
            return null;
        }
        block = this.putBlockContentsInAutomaton(block, serial, lastFile.getName(), this);
        block.setName(lastFile.getName().substring(0, lastFile.getName().length() - 4));
        this.addState(block);
        return block;
    }

    private State putBlockContentsInAutomaton(State block, Serializable serial, String name, Automaton target) {
        if (serial instanceof Automaton) {
            Automaton automaton = (Automaton)serial;
            automaton.setEnvironmentFrame(target.getEnvironmentFrame());
            block.setInternalName(name);
            if (!target.getBlockMap().containsKey(name)) {
                target.getBlockMap().put(name, automaton);
            }
            State[] newStates = automaton.getStates();
            int k = 0;
            while (k < newStates.length) {
                State cur = newStates[k];
                cur.setParentBlock(block);
                if (automaton.isFinalState(cur)) {
                    cur.setFinalStateInBlock(true);
                }
                cur.setAutomaton(target);
                List fromList = Automaton.makeListFromArray(automaton.getTransitionsFromState(cur));
                List toList = Automaton.makeListFromArray(automaton.getTransitionsToState(cur));
                target.transitionFromStateMap.put(cur, fromList);
                target.transitionToStateMap.put(cur, toList);
                ++k;
            }
        }
        return block;
    }

    public final State createBlockFromAutomaton(Point point, Serializable auto, String name, int i) {
        State block = new State(i, point, this);
        this.putBlockContentsInAutomaton(block, auto, name, this);
        this.addState(block);
        return block;
    }

    public final void replaceBlock(State block, Automaton inside) {
        if ((Automaton)this.blockMap.get(block.getInternalName()) == null) {
            JOptionPane.showMessageDialog(null, "JFLAP failed to find the block you were editing, your changes have not taken effect.", "Error", 0);
            return;
        }
        List fromList = Automaton.makeListFromArray(this.getTransitionsFromState(block));
        List toList = Automaton.makeListFromArray(this.getTransitionsToState(block));
        int found = 0;
        boolean initial = false;
        boolean finalState = false;
        State[] states = this.getStates();
        int k = 0;
        while (k < states.length) {
            State temp = states[k];
            if (temp.getInternalName() != null && temp.getInternalName().equals(block.getInternalName())) {
                if (temp.getID() == block.getID()) {
                    if (this.getInitialState() == block) {
                        initial = true;
                    }
                    State[] finals = this.getFinalStates();
                    int m = 0;
                    while (m < finals.length) {
                        if (finals[m] == block) {
                            this.removeFinalState(block);
                            finalState = true;
                        }
                        ++m;
                    }
                    this.removeState(temp);
                }
                ++found;
            }
            ++k;
        }
        if (found == 1) {
            this.blockMap.remove(block.getInternalName());
        }
        State newBlock = new State(block.getID(), block.getPoint(), this);
        String newName = block.getInternalName();
        if (found > 1) {
            int add = block.getID();
            while (this.getBlockMap().containsKey(newName)) {
                newName = newName.concat(Integer.toString(add));
                ++add;
            }
        }
        newBlock.setLabel(block.getLabel());
        newBlock.setName(block.getName());
        newBlock.setParentBlock(block.getParentBlock());
        newBlock.setInternalName(newName);
        this.putBlockContentsInAutomaton(newBlock, inside, newBlock.getInternalName(), this);
        this.addState(newBlock);
        if (initial) {
            this.setInitialState(newBlock);
        }
        if (finalState) {
            this.addFinalState(newBlock);
        }
        int k2 = 0;
        while (k2 < fromList.size()) {
            Transition tempFrom = (Transition)fromList.get(k2);
            tempFrom.setFromState(newBlock);
            this.addTransition(tempFrom);
            ++k2;
        }
        k2 = 0;
        while (k2 < toList.size()) {
            Transition tempTo = (Transition)toList.get(k2);
            tempTo.setToState(newBlock);
            this.addTransition(tempTo);
            ++k2;
        }
    }

    public static List makeListFromArray(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        int k = 0;
        while (k < array.length) {
            list.add(array[k]);
            ++k;
        }
        return list;
    }

    public final State createState(Point point) {
        int i = 0;
        while (this.getStateWithID(i) != null) {
            ++i;
        }
        State state = new State(i, point, this);
        this.addState(state);
        return state;
    }

    public final State createStateWithId(Point point, int i) {
        State state = new State(i, point, this);
        this.addState(state);
        return state;
    }

    protected final void addState(State state) {
        this.states.add(state);
        this.transitionFromStateMap.put(state, new LinkedList());
        this.transitionToStateMap.put(state, new LinkedList());
        this.cachedStates = null;
        this.distributeStateEvent(new AutomataStateEvent(this, state, true, false, false));
    }

    public void removeState(State state) {
        Transition[] t = this.getTransitionsFromState(state);
        int i = 0;
        while (i < t.length) {
            this.removeTransition(t[i]);
            ++i;
        }
        t = this.getTransitionsToState(state);
        i = 0;
        while (i < t.length) {
            this.removeTransition(t[i]);
            ++i;
        }
        this.distributeStateEvent(new AutomataStateEvent(this, state, false, false, false));
        this.states.remove(state);
        this.finalStates.remove(state);
        if (state == this.initialState) {
            this.initialState = null;
        }
        this.transitionFromStateMap.remove(state);
        this.transitionToStateMap.remove(state);
        this.transitionArrayFromStateMap.remove(state);
        this.transitionArrayToStateMap.remove(state);
        this.cachedStates = null;
        Iterator statIt = this.states.iterator();
        while (statIt.hasNext()) {
            State temp = (State)statIt.next();
            if (temp.getParentBlock() == null || !temp.getParentBlock().equals(state)) continue;
            this.removeState(temp);
        }
    }

    public State setInitialState(State initialState) {
        State oldInitialState = this.initialState;
        this.initialState = initialState;
        return oldInitialState;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public State[] getStates() {
        if (this.cachedStates == null) {
            this.cachedStates = this.states.toArray(new State[0]);
            Arrays.sort(this.cachedStates, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((State)o1).getID() - ((State)o2).getID();
                }

                public boolean equals(Object o) {
                    return this == o;
                }
            });
        }
        return this.cachedStates;
    }

    public void selectStatesWithinBounds(Rectangle bounds) {
        State[] states = this.getStates();
        int k = 0;
        while (k < states.length) {
            states[k].setSelect(false);
            if (bounds.contains(states[k].getPoint())) {
                states[k].setSelect(true);
            }
            ++k;
        }
    }

    public ArrayList getNotes() {
        return this.myNotes;
    }

    public void addNote(Note note) {
        this.myNotes.add(note);
    }

    public void deleteNote(Note note) {
        int k = 0;
        while (k < this.myNotes.size()) {
            if (note == this.myNotes.get(k)) {
                this.myNotes.remove(k);
            }
            ++k;
        }
    }

    public void addFinalState(State finalState) {
        this.cachedFinalStates = null;
        this.finalStates.add(finalState);
    }

    public void removeFinalState(State state) {
        this.cachedFinalStates = null;
        this.finalStates.remove(state);
    }

    public State[] getFinalStates() {
        if (this.cachedFinalStates == null) {
            this.cachedFinalStates = this.finalStates.toArray(new State[0]);
        }
        return this.cachedFinalStates;
    }

    public boolean isFinalState(State state) {
        return this.finalStates.contains(state);
    }

    public State getStateWithID(int id) {
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            State state = (State)it.next();
            if (state.getID() != id) continue;
            return state;
        }
        return null;
    }

    public boolean isState(State state) {
        return this.states.contains(state);
    }

    protected Class getTransitionClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("automata.Transition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append('\n');
        State[] states = this.getStates();
        int s = 0;
        while (s < states.length) {
            if (this.initialState == states[s]) {
                buffer.append("--> ");
            }
            buffer.append(states[s]);
            if (this.isFinalState(states[s])) {
                buffer.append(" **FINAL**");
            }
            buffer.append('\n');
            Transition[] transitions = this.getTransitionsFromState(states[s]);
            int t = 0;
            while (t < transitions.length) {
                buffer.append('\t');
                buffer.append(transitions[t]);
                buffer.append('\n');
                ++t;
            }
            ++s;
        }
        return buffer.toString();
    }

    public void addStateListener(AutomataStateListener listener) {
        this.stateListeners.add(listener);
    }

    public void addTransitionListener(AutomataTransitionListener listener) {
        this.transitionListeners.add(listener);
    }

    void distributeStateEvent(AutomataStateEvent event) {
        Iterator it = this.stateListeners.iterator();
        while (it.hasNext()) {
            AutomataStateListener listener = (AutomataStateListener)it.next();
            listener.automataStateChange(event);
        }
    }

    public void removeStateListener(AutomataStateListener listener) {
        this.stateListeners.remove(listener);
    }

    public void removeTransitionListener(AutomataTransitionListener listener) {
        this.transitionListeners.remove(listener);
    }

    void distributeTransitionEvent(AutomataTransitionEvent event) {
        Iterator it = this.transitionListeners.iterator();
        while (it.hasNext()) {
            AutomataTransitionListener listener = (AutomataTransitionListener)it.next();
            listener.automataTransitionChange(event);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.transitionListeners = new HashSet();
        this.stateListeners = new HashSet();
        this.transitionFromStateMap = new HashMap();
        this.transitionToStateMap = new HashMap();
        this.transitionArrayFromStateMap = new HashMap();
        this.transitionArrayToStateMap = new HashMap();
        this.transitions = new HashSet();
        this.states = new HashSet();
        int version = in.readInt();
        if (version >= 0) {
            Set s = (Set)in.readObject();
            Iterator it = s.iterator();
            while (it.hasNext()) {
                this.addState((State)it.next());
            }
            this.initialState = (State)in.readObject();
            this.finalStates = (Set)in.readObject();
            Set trans = (Set)in.readObject();
            it = trans.iterator();
            while (it.hasNext()) {
                this.addTransition((Transition)it.next());
            }
            if (this instanceof TuringMachine) {
                ((TuringMachine)this).tapes = in.readInt();
            }
        }
        while (!in.readObject().equals("SENT")) {
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.states);
        out.writeObject(this.initialState);
        out.writeObject(this.finalStates);
        out.writeObject(this.transitions);
        if (this instanceof TuringMachine) {
            out.writeInt(((TuringMachine)this).tapes);
        }
        out.writeObject("SENT");
    }

    public Map getBlockMap() {
        return this.blockMap;
    }

    public EnvironmentFrame getEnvironmentFrame() {
        return this.myEnvFrame;
    }

    public void setEnvironmentFrame(EnvironmentFrame frame) {
        this.myEnvFrame = frame;
    }

    public void setFilePath(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        int last = this.fileName.lastIndexOf("\\");
        if (last == -1) {
            last = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(last + 1);
    }

    public String getFilePath() {
        int last = this.fileName.lastIndexOf("\\");
        if (last == -1) {
            last = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(0, last + 1);
    }
}

