/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.State;
import java.util.Stack;

public abstract class Configuration
implements Cloneable {
    private Stack parentAutos = new Stack();
    private Stack parentBlocks = new Stack();
    private boolean focused = false;
    private State myCurrentState;
    private Configuration parent;

    public Configuration(State state, Configuration parent) {
        this.myCurrentState = state;
        this.parent = parent;
    }

    public State getCurrentState() {
        return this.myCurrentState;
    }

    public void setCurrentState(State state) {
        this.myCurrentState = state;
    }

    public String toString() {
        return "[" + this.getCurrentState().toString() + "]";
    }

    public Configuration getParent() {
        return this.parent;
    }

    public abstract boolean isAccept();

    public boolean equals(Object configuration) {
        Configuration config = (Configuration)configuration;
        if (this.parent != config.parent) {
            return false;
        }
        return config.myCurrentState == this.myCurrentState;
    }

    public int hashCode() {
        return this.myCurrentState.hashCode() ^ (this.parent == null ? 0 : this.parent.primitiveHashCode());
    }

    private int primitiveHashCode() {
        return super.hashCode();
    }

    public boolean getFocused() {
        return this.focused;
    }

    public void setFocused(boolean focus) {
        this.focused = focus;
    }

    public Stack getAutoStack() {
        return this.parentAutos;
    }

    public void setAutoStack(Stack autos) {
        this.parentAutos = autos;
    }

    public Stack getBlockStack() {
        return this.parentBlocks;
    }

    public void setBlockStack(Stack blocks) {
        this.parentBlocks = blocks;
    }

    public void reset() {
        this.setFocused(false);
    }
}

