/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.Note;
import automata.event.AutomataStateEvent;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class State
implements Serializable {
    private Note myNote;
    String internalName = null;
    private Point point;
    int id;
    String name = null;
    private static final char SS = '\u2080';
    private Automaton automaton = null;
    private String label;
    private String[] labels = new String[0];
    private State parentBlock = null;
    private boolean finalStateInBlock = false;
    private boolean selected = false;

    public State(int id, Point point, Automaton automaton) {
        this.point = point;
        this.id = id;
        this.automaton = automaton;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setAutomaton(Automaton auto) {
        this.automaton = auto;
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public void setPoint(Point point) {
        this.point = point;
        this.getAutomaton().distributeStateEvent(new AutomataStateEvent(this.getAutomaton(), this, false, true, false));
    }

    public int getID() {
        return this.id;
    }

    protected void setID(int id) {
        if (("q" + this.id).equals(this.name)) {
            this.name = null;
        }
        this.id = id;
        this.getAutomaton().distributeStateEvent(new AutomataStateEvent(this.getAutomaton(), this, false, false, true));
    }

    public String toString() {
        return "q_" + Integer.toString(this.getID()) + " at (" + Integer.toString(this.getPoint().x) + "," + Integer.toString(this.getPoint().y) + ")" + " label: " + this.getLabel();
    }

    public void setName(String name) {
        this.name = name;
        this.getAutomaton().distributeStateEvent(new AutomataStateEvent(this.getAutomaton(), this, false, false, true));
    }

    public String getName() {
        if (this.name == null) {
            this.name = "q" + Integer.toString(this.getID());
        }
        return this.name;
    }

    private String digitizer(int number) {
        if (number == 0) {
            return "\u2080";
        }
        String s = this.digitizer(number / 10, 1);
        return String.valueOf(s) + (8320 + (char)(number % 10));
    }

    private String digitizer(int number, int supp) {
        if (number == 0) {
            return "";
        }
        String s = this.digitizer(number / 10, 1);
        return String.valueOf(s) + (8320 + (char)(number % 10));
    }

    public void setLabel(String label) {
        this.label = label;
        if (label == null) {
            this.labels = new String[0];
        } else {
            StringTokenizer st = new StringTokenizer(label, "\n");
            ArrayList<String> lines = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
            this.labels = lines.toArray(new String[0]);
        }
        this.getAutomaton().distributeStateEvent(new AutomataStateEvent(this.getAutomaton(), this, false, false, true));
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public State getParentBlock() {
        return this.parentBlock;
    }

    public void setParentBlock(State block) {
        this.parentBlock = block;
    }

    public boolean getFinalStateInBlock() {
        return this.finalStateInBlock;
    }

    public void setFinalStateInBlock(boolean type) {
        this.finalStateInBlock = type;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String auto) {
        this.internalName = auto;
    }

    public void setNote(Note note) {
        this.myNote = note;
    }

    public void setSelect(boolean select) {
        this.selected = select;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

