/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.Configuration;
import automata.State;

public class FSAConfiguration
extends Configuration {
    private String myInput;
    private String myUnprocessedInput;

    public FSAConfiguration(State state, FSAConfiguration parent, String input, String unprocessed) {
        super(state, parent);
        this.myInput = input;
        this.myUnprocessedInput = unprocessed;
    }

    public String getInput() {
        return this.myInput;
    }

    public String getUnprocessedInput() {
        return this.myUnprocessedInput;
    }

    public void setUnprocessedInput(String input) {
        this.myUnprocessedInput = input;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.getUnprocessedInput();
    }

    public boolean isAccept() {
        if (this.getUnprocessedInput().length() != 0) {
            return false;
        }
        State s = this.getCurrentState();
        Automaton a = s.getAutomaton();
        return a.isFinalState(s);
    }

    public boolean equals(Object configuration) {
        if (configuration == this) {
            return true;
        }
        try {
            return super.equals(configuration) && this.myUnprocessedInput.equals(((FSAConfiguration)configuration).myUnprocessedInput);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.myUnprocessedInput.hashCode();
    }
}

