/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import java.awt.Point;

public class FSALabelHandler {
    public boolean hasMultipleCharacterLabels(Automaton automaton) {
        Transition[] transitions = automaton.getTransitions();
        int k = 0;
        while (k < transitions.length) {
            FSATransition transition = (FSATransition)transitions[k];
            String label = transition.getLabel();
            if (label.length() > 1) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public void handleLabel(Transition transition, Automaton automaton) {
        State from;
        FSATransition trans = (FSATransition)transition;
        State f = from = transition.getFromState();
        State to = transition.getToState();
        automaton.removeTransition(trans);
        String label = trans.getLabel();
        int length = label.length();
        int i = 0;
        while (i < length) {
            State going = i == length - 1 ? to : automaton.createState(new Point((f.getPoint().x * (length - i - 1) + to.getPoint().x * (i + 1)) / length, (f.getPoint().y * (length - i - 1) + to.getPoint().y * (i + 1)) / length));
            FSATransition newTrans = new FSATransition(from, going, label.substring(i, i + 1));
            automaton.addTransition(newTrans);
            from = going;
            ++i;
        }
    }

    public FiniteStateAutomaton removeMultipleCharacterLabels(Automaton automaton) {
        FiniteStateAutomaton fsa = (FiniteStateAutomaton)automaton.clone();
        Transition[] transitions = fsa.getTransitions();
        int k = 0;
        while (k < transitions.length) {
            FSATransition transition = (FSATransition)transitions[k];
            String label = transition.getLabel();
            if (label.length() > 1) {
                this.handleLabel(transition, fsa);
            }
            ++k;
        }
        return fsa;
    }

    public void removeMultipleCharacterLabelsFromAutomaton(Automaton automaton) {
        Transition[] transitions = automaton.getTransitions();
        int k = 0;
        while (k < transitions.length) {
            FSATransition transition = (FSATransition)transitions[k];
            String label = transition.getLabel();
            if (label.length() > 1) {
                this.handleLabel(transition, automaton);
            }
            ++k;
        }
    }
}

