/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.fsa.FSAConfiguration;
import automata.fsa.FSATransition;
import java.util.ArrayList;
import java.util.Iterator;

public class FSAStepByStateSimulator
extends AutomatonSimulator {
    public FSAStepByStateSimulator(Automaton automaton) {
        super(automaton);
    }

    public Configuration[] getInitialConfigurations(String input) {
        Configuration[] configs = new Configuration[]{new FSAConfiguration(this.myAutomaton.getInitialState(), null, input, input)};
        return configs;
    }

    public ArrayList stepConfiguration(Configuration config) {
        ArrayList<FSAConfiguration> list = new ArrayList<FSAConfiguration>();
        FSAConfiguration configuration = (FSAConfiguration)config;
        String unprocessedInput = configuration.getUnprocessedInput();
        String totalInput = configuration.getInput();
        State currentState = configuration.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int k = 0;
        while (k < transitions.length) {
            FSATransition transition = (FSATransition)transitions[k];
            String transLabel = transition.getLabel();
            if (unprocessedInput.startsWith(transLabel)) {
                String input = "";
                if (transLabel.length() < unprocessedInput.length()) {
                    input = unprocessedInput.substring(transLabel.length());
                }
                State toState = transition.getToState();
                FSAConfiguration configurationToAdd = new FSAConfiguration(toState, configuration, totalInput, input);
                list.add(configurationToAdd);
            }
            ++k;
        }
        return list;
    }

    public boolean isAccepted() {
        Iterator it = this.myConfigurations.iterator();
        while (it.hasNext()) {
            FSAConfiguration configuration = (FSAConfiguration)it.next();
            State currentState = configuration.getCurrentState();
            if (configuration.getUnprocessedInput() != "" || !this.myAutomaton.isFinalState(currentState)) continue;
            return true;
        }
        return false;
    }

    public boolean simulateInput(String input) {
        this.myConfigurations.clear();
        Configuration[] initialConfigs = this.getInitialConfigurations(input);
        int k = 0;
        while (k < initialConfigs.length) {
            FSAConfiguration initialConfiguration = (FSAConfiguration)initialConfigs[k];
            this.myConfigurations.add(initialConfiguration);
            ++k;
        }
        while (!this.myConfigurations.isEmpty()) {
            if (this.isAccepted()) {
                return true;
            }
            ArrayList configurationsToAdd = new ArrayList();
            Iterator it = this.myConfigurations.iterator();
            while (it.hasNext()) {
                FSAConfiguration configuration = (FSAConfiguration)it.next();
                ArrayList configsToAdd = this.stepConfiguration(configuration);
                configurationsToAdd.addAll(configsToAdd);
                it.remove();
            }
            this.myConfigurations.addAll(configurationsToAdd);
        }
        return false;
    }
}

