/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.ClosureTaker;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.fsa.FSAConfiguration;
import automata.fsa.FSAStepByStateSimulator;
import automata.fsa.FSATransition;
import java.util.ArrayList;

public class FSAStepWithClosureSimulator
extends FSAStepByStateSimulator {
    public FSAStepWithClosureSimulator(Automaton automaton) {
        super(automaton);
    }

    public Configuration[] getInitialConfigurations(String input) {
        State init = this.myAutomaton.getInitialState();
        State[] closure = ClosureTaker.getClosure(init, this.myAutomaton);
        Configuration[] configs = new Configuration[closure.length];
        int k = 0;
        while (k < closure.length) {
            configs[k] = new FSAConfiguration(closure[k], null, input, input);
            ++k;
        }
        return configs;
    }

    public ArrayList stepConfiguration(Configuration config) {
        ArrayList<FSAConfiguration> list = new ArrayList<FSAConfiguration>();
        FSAConfiguration configuration = (FSAConfiguration)config;
        String unprocessedInput = configuration.getUnprocessedInput();
        String totalInput = configuration.getInput();
        State currentState = configuration.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int k = 0;
        while (k < transitions.length) {
            FSATransition transition = (FSATransition)transitions[k];
            String transLabel = transition.getLabel();
            if (transLabel.length() > 0 && unprocessedInput.startsWith(transLabel)) {
                String input = "";
                if (transLabel.length() < unprocessedInput.length()) {
                    input = unprocessedInput.substring(transLabel.length());
                }
                State toState = transition.getToState();
                State[] closure = ClosureTaker.getClosure(toState, this.myAutomaton);
                int i = 0;
                while (i < closure.length) {
                    FSAConfiguration configurationToAdd = new FSAConfiguration(closure[i], configuration, totalInput, input);
                    list.add(configurationToAdd);
                    ++i;
                }
            }
            ++k;
        }
        return list;
    }
}

