/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.Universe;
import java.util.ArrayList;
import regular.Discretizer;

public class FSAToRegularExpressionConverter {
    public static String EMPTY = "\u00f8";
    public static String LAMBDA_DISPLAY = Universe.curProfile.getEmptyString();
    public static String LAMBDA = "";
    public static String KLEENE_STAR = "*";
    public static String OR = "+";
    public static String RIGHT_PAREN = ")";
    public static String LEFT_PAREN = "(";

    public boolean isConvertable(Automaton automaton) {
        if (!(automaton instanceof FiniteStateAutomaton)) {
            return false;
        }
        State[] finalStates = automaton.getFinalStates();
        if (finalStates.length != 1) {
            return false;
        }
        State initialState = automaton.getInitialState();
        return finalStates[0] != initialState;
    }

    public boolean areRemovableStates(Automaton automaton) {
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            if (this.isRemovable(states[k], automaton)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean isRemovable(State state, Automaton automaton) {
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        State initialState = automaton.getInitialState();
        return state != finalState && state != initialState;
    }

    public Transition getTransitionForExpression(int p, int q, String expression, Automaton automaton) {
        State fromState = automaton.getStateWithID(p);
        State toState = automaton.getStateWithID(q);
        FSATransition transition = new FSATransition(fromState, toState, expression);
        return transition;
    }

    public String getExpressionBetweenStates(State fromState, State toState, Automaton automaton) {
        Transition[] transitions = automaton.getTransitionsFromStateToState(fromState, toState);
        FSATransition trans = (FSATransition)transitions[0];
        return trans.getLabel();
    }

    public String getExpression(int p, int q, int k, Automaton automaton) {
        State fromState = automaton.getStateWithID(p);
        State toState = automaton.getStateWithID(q);
        State removeState = automaton.getStateWithID(k);
        String pq = this.getExpressionBetweenStates(fromState, toState, automaton);
        String pk = this.getExpressionBetweenStates(fromState, removeState, automaton);
        String kk = this.getExpressionBetweenStates(removeState, removeState, automaton);
        String kq = this.getExpressionBetweenStates(removeState, toState, automaton);
        String temp1 = this.star(kk);
        String temp2 = this.concatenate(pk, temp1);
        String temp3 = this.concatenate(temp2, kq);
        String label = this.or(pq, temp3);
        return label;
    }

    public String concatenate(String r1, String r2) {
        if (r1.equals(EMPTY) || r2.equals(EMPTY)) {
            return EMPTY;
        }
        if (r1.equals(LAMBDA)) {
            return r2;
        }
        if (r2.equals(LAMBDA)) {
            return r1;
        }
        if (Discretizer.or(r1).length > 1) {
            r1 = this.addParen(r1);
        }
        if (Discretizer.or(r2).length > 1) {
            r2 = this.addParen(r2);
        }
        return String.valueOf(r1) + r2;
    }

    public String star(String r1) {
        if (r1.equals(EMPTY) || r1.equals(LAMBDA)) {
            return LAMBDA;
        }
        if (Discretizer.or(r1).length > 1 || Discretizer.cat(r1).length > 1) {
            r1 = this.addParen(r1);
        } else if (r1.endsWith(KLEENE_STAR)) {
            return r1;
        }
        return String.valueOf(r1) + KLEENE_STAR;
    }

    public String or(String r1, String r2) {
        if (r1.equals(EMPTY)) {
            return r2;
        }
        if (r2.equals(EMPTY)) {
            return r1;
        }
        if (r1.equals(LAMBDA) && r2.equals(LAMBDA)) {
            return LAMBDA;
        }
        if (r1.equals(LAMBDA)) {
            r1 = LAMBDA_DISPLAY;
        }
        if (r2.equals(LAMBDA)) {
            r2 = LAMBDA_DISPLAY;
        }
        return String.valueOf(r1) + OR + r2;
    }

    public void removeState(State state, Transition[] transitions, Automaton automaton) {
        Transition[] oldTransitions = automaton.getTransitions();
        int k = 0;
        while (k < oldTransitions.length) {
            automaton.removeTransition(oldTransitions[k]);
            ++k;
        }
        automaton.removeState(state);
        int i = 0;
        while (i < transitions.length) {
            automaton.addTransition(transitions[i]);
            ++i;
        }
    }

    public Transition[] getTransitionsForRemoveState(State state, Automaton automaton) {
        if (!this.isRemovable(state, automaton)) {
            return null;
        }
        ArrayList<Transition> list = new ArrayList<Transition>();
        int k = state.getID();
        State[] states = automaton.getStates();
        int i = 0;
        while (i < states.length) {
            int p = states[i].getID();
            if (p != k) {
                int j = 0;
                while (j < states.length) {
                    int q = states[j].getID();
                    if (q != k) {
                        String exp = this.getExpression(p, q, k, automaton);
                        list.add(this.getTransitionForExpression(p, q, exp, automaton));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new Transition[0]);
    }

    public FSATransition addTransitionOnEmptySet(State fromState, State toState, Automaton automaton) {
        FSATransition t = new FSATransition(fromState, toState, EMPTY);
        automaton.addTransition(t);
        return t;
    }

    public FSATransition combineToSingleTransition(State fromState, State toState, Transition[] transitions, Automaton automaton) {
        String label = ((FSATransition)transitions[0]).getDescription();
        automaton.removeTransition(transitions[0]);
        int i = 1;
        while (i < transitions.length) {
            label = this.or(label, ((FSATransition)transitions[i]).getDescription());
            automaton.removeTransition(transitions[i]);
            ++i;
        }
        FSATransition t = new FSATransition(fromState, toState, label);
        automaton.addTransition(t);
        return t;
    }

    public void getSingleFinalState(Automaton automaton) {
        StatePlacer sp = new StatePlacer();
        State finalState = automaton.createState(sp.getPointForState(automaton));
        State[] finalStates = automaton.getFinalStates();
        int k = 0;
        while (k < finalStates.length) {
            State state = finalStates[k];
            automaton.addTransition(new FSATransition(state, finalState, LAMBDA));
            automaton.removeFinalState(state);
            ++k;
        }
        automaton.addFinalState(finalState);
    }

    public void convertToSimpleAutomaton(Automaton automaton) {
        if (!this.isConvertable(automaton)) {
            this.getSingleFinalState(automaton);
        }
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            int j = 0;
            while (j < states.length) {
                Transition[] transitions = automaton.getTransitionsFromStateToState(states[k], states[j]);
                if (transitions.length == 0) {
                    this.addTransitionOnEmptySet(states[k], states[j], automaton);
                }
                if (transitions.length > 1) {
                    this.combineToSingleTransition(states[k], states[j], transitions, automaton);
                }
                ++j;
            }
            ++k;
        }
    }

    public void convertToGTG(Automaton automaton) {
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        State initialState = automaton.getInitialState();
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            State state = states[k];
            if (state != finalState && state != initialState) {
                Transition[] transitions = this.getTransitionsForRemoveState(state, automaton);
                this.removeState(state, transitions, automaton);
            }
            ++k;
        }
    }

    public boolean isSingleCharacter(String word) {
        if (word.length() != 1) {
            return false;
        }
        char ch = word.charAt(0);
        return Character.isLetter(ch);
    }

    public boolean needsParens(String word) {
        int k = 0;
        while (k < word.length()) {
            char ch = word.charAt(k);
            if (ch == '+') {
                return true;
            }
            ++k;
        }
        return false;
    }

    public String addParen(String word) {
        return String.valueOf(LEFT_PAREN) + word + RIGHT_PAREN;
    }

    public String getExp(String word) {
        if (word.equals(LAMBDA)) {
            return "lambda";
        }
        if (word.equals(EMPTY)) {
            return "empty";
        }
        return word;
    }

    public String getFinalExpression(String ii, String ij, String jj, String ji) {
        String temp = this.concatenate(this.star(ii), this.concatenate(ij, this.concatenate(this.star(jj), ji)));
        String temp2 = this.concatenate(this.star(ii), this.concatenate(ij, this.star(jj)));
        String expression = this.concatenate(this.star(temp), temp2);
        return expression;
    }

    public String getII(Automaton automaton) {
        State initialState = automaton.getInitialState();
        return this.getExpressionBetweenStates(initialState, initialState, automaton);
    }

    public String getIJ(Automaton automaton) {
        State initialState = automaton.getInitialState();
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        return this.getExpressionBetweenStates(initialState, finalState, automaton);
    }

    public String getJJ(Automaton automaton) {
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        return this.getExpressionBetweenStates(finalState, finalState, automaton);
    }

    public String getJI(Automaton automaton) {
        State initialState = automaton.getInitialState();
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        return this.getExpressionBetweenStates(finalState, initialState, automaton);
    }

    public String getExpressionFromGTG(Automaton automaton) {
        String ii = this.getII(automaton);
        String ij = this.getIJ(automaton);
        String jj = this.getJJ(automaton);
        String ji = this.getJI(automaton);
        return this.getFinalExpression(ii, ij, jj, ji);
    }

    public String convertToRegularExpression(Automaton automaton) {
        if (!this.isConvertable(automaton)) {
            return null;
        }
        this.convertToGTG(automaton);
        return this.getExpressionFromGTG(automaton);
    }
}

