/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import grammar.Production;
import grammar.reg.RegularGrammar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class FSAToRegularGrammarConverter {
    protected HashMap MAP;
    protected static final String START_VARIABLE = "S";
    protected static final String LAMBDA = "";
    protected LinkedList VARIABLE;

    public void initializeConverter(Automaton automaton) {
        this.MAP = new HashMap();
        State[] states = automaton.getStates();
        State initialState = automaton.getInitialState();
        this.VARIABLE = new LinkedList();
        char c = 'A';
        while (c <= 'Z') {
            this.VARIABLE.add(LAMBDA + c);
            c = (char)(c + '\u0001');
        }
        if (initialState != null) {
            this.VARIABLE.remove(START_VARIABLE);
            this.MAP.put(initialState, START_VARIABLE);
        }
        ArrayList<State> stateList = new ArrayList<State>(Arrays.asList(states));
        stateList.remove(initialState);
        Collections.sort(stateList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((State)o1).getID() - ((State)o2).getID();
            }

            public boolean equals(Object o) {
                return false;
            }
        });
        Iterator it = stateList.iterator();
        while (it.hasNext()) {
            State state = (State)it.next();
            this.MAP.put(state, this.VARIABLE.removeFirst());
        }
    }

    public Production getProductionForTransition(Transition transition) {
        FSATransition trans = (FSATransition)transition;
        State toState = trans.getToState();
        State fromState = trans.getFromState();
        String label = trans.getLabel();
        String lhs = (String)this.MAP.get(fromState);
        String rhs = label.concat((String)this.MAP.get(toState));
        Production production = new Production(lhs, rhs);
        return production;
    }

    public Production getLambdaProductionForFinalState(Automaton automaton, State state) {
        if (!automaton.isFinalState(state)) {
            System.err.println(state + " IS NOT A FINAL STATE");
            return null;
        }
        String llhs = (String)this.MAP.get(state);
        String lrhs = LAMBDA;
        Production lprod = new Production(llhs, lrhs);
        return lprod;
    }

    public RegularGrammar convertToRegularGrammar(Automaton automaton) {
        if (!(automaton instanceof FiniteStateAutomaton)) {
            System.err.println("ATTEMPTING TO CONVERT NON FSA TO REGULAR GRAMMAR");
            return null;
        }
        RegularGrammar grammar = new RegularGrammar();
        this.initializeConverter(automaton);
        Transition[] transitions = automaton.getTransitions();
        int k = 0;
        while (k < transitions.length) {
            Production production = this.getProductionForTransition(transitions[k]);
            grammar.addProduction(production);
            ++k;
        }
        State[] finalStates = automaton.getFinalStates();
        int j = 0;
        while (j < finalStates.length) {
            Production lprod = this.getLambdaProductionForFinalState(automaton, finalStates[j]);
            grammar.addProduction(lprod);
            ++j;
        }
        return grammar;
    }

    public String variableForState(State state) {
        return (String)this.MAP.get(state);
    }
}

