/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import automata.Automaton;
import automata.State;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DisjointSetsDetector {
    protected ArrayList STATES_IN_A_SET = new ArrayList();

    private void accountForStates(HashSet states) {
        Iterator it = states.iterator();
        while (it.hasNext()) {
            State state = (State)it.next();
            if (this.STATES_IN_A_SET.contains(state)) continue;
            this.STATES_IN_A_SET.add(state);
        }
    }

    private boolean areDirectlyConnected(State s1, State s2, Automaton automaton) {
        if (s1 == s2) {
            return false;
        }
        return automaton.getTransitionsFromStateToState(s1, s2).length != 0 || automaton.getTransitionsFromStateToState(s2, s1).length != 0;
    }

    private ArrayList getStatesConnectedToState(State state, Automaton automaton) {
        ArrayList<State> list = new ArrayList<State>();
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            if (this.areDirectlyConnected(state, states[k], automaton)) {
                list.add(states[k]);
            }
            ++k;
        }
        return list;
    }

    private void addAllNotInSetToList(ArrayList toAdd, HashSet set, ArrayList list) {
        Iterator it = toAdd.iterator();
        while (it.hasNext()) {
            State state = (State)it.next();
            if (set.contains(state)) continue;
            list.add(state);
        }
    }

    public HashSet getSetIncludingState(State state, Automaton automaton) {
        HashSet<State> set = new HashSet<State>();
        ArrayList<State> list = new ArrayList<State>();
        list.add(state);
        while (!list.isEmpty()) {
            ArrayList toAdd = new ArrayList();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                State s = (State)it.next();
                toAdd.addAll(this.getStatesConnectedToState(s, automaton));
                set.add(s);
                it.remove();
            }
            this.addAllNotInSetToList(toAdd, set, list);
        }
        return set;
    }

    private boolean isAccountedFor(State state) {
        return this.STATES_IN_A_SET.contains(state);
    }

    private boolean accountedForAllStates(Automaton automaton) {
        return this.getUnaccountedForState(automaton) == null;
    }

    public State getUnaccountedForState(Automaton automaton) {
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            if (!this.isAccountedFor(states[k])) {
                return states[k];
            }
            ++k;
        }
        return null;
    }

    public HashSet[] getDisjointSets(Automaton automaton) {
        ArrayList<HashSet> list = new ArrayList<HashSet>();
        this.STATES_IN_A_SET = new ArrayList();
        while (!this.accountedForAllStates(automaton)) {
            State state = this.getUnaccountedForState(automaton);
            HashSet set = this.getSetIncludingState(state, automaton);
            this.accountForStates(set);
            list.add(set);
        }
        return list.toArray(new HashSet[0]);
    }
}

