/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Graph {
    private Map verticesToPoints = new HashMap();
    private Map verticesToNeighbors = new HashMap();

    public void clear() {
        this.verticesToPoints.clear();
        this.verticesToNeighbors.clear();
    }

    public int degree(Object vertex) {
        return this.adjacent(vertex).size();
    }

    public int numberOfVertices() {
        return this.verticesToPoints.size();
    }

    public Set adjacent(Object vertex) {
        if (!this.verticesToNeighbors.containsKey(vertex)) {
            this.verticesToNeighbors.put(vertex, new HashSet());
        }
        return (Set)this.verticesToNeighbors.get(vertex);
    }

    public void addEdge(Object vertex1, Object vertex2) {
        this.adjacent(vertex1).add(vertex2);
        this.adjacent(vertex2).add(vertex1);
    }

    public void removeEdge(Object vertex1, Object vertex2) {
        this.adjacent(vertex1).remove(vertex2);
        this.adjacent(vertex2).remove(vertex1);
    }

    public boolean hasEdge(Object vertex1, Object vertex2) {
        return this.adjacent(vertex1).contains(vertex2);
    }

    public void addVertex(Object vertex, Point2D point) {
        this.verticesToPoints.put(vertex, point.clone());
    }

    public void removeVertex(Object vertex) {
        Set others = this.adjacent(vertex);
        Iterator it = others.iterator();
        while (it.hasNext()) {
            this.adjacent(it.next()).remove(vertex);
        }
        this.verticesToNeighbors.remove(vertex);
        this.verticesToPoints.remove(vertex);
    }

    public void moveVertex(Object vertex, Point2D point) {
        this.addVertex(vertex, point);
    }

    public Point2D pointForVertex(Object vertex) {
        return (Point2D)this.verticesToPoints.get(vertex);
    }

    public Object[] vertices() {
        return this.verticesToPoints.keySet().toArray();
    }

    public Point2D[] points() {
        return this.verticesToPoints.values().toArray(new Point2D[0]);
    }

    public void moveWithinFrame(Rectangle2D bounds) {
        Object[] vertices = this.vertices();
        if (vertices.length == 0) {
            return;
        }
        Point2D p = this.pointForVertex(vertices[0]);
        double minx = p.getX();
        double miny = p.getY();
        double maxx = minx;
        double maxy = miny;
        int i = 1;
        while (i < vertices.length) {
            p = this.pointForVertex(vertices[i]);
            minx = Math.min(minx, p.getX());
            miny = Math.min(miny, p.getY());
            maxx = Math.max(maxx, p.getX());
            maxy = Math.max(maxy, p.getY());
            ++i;
        }
        i = 0;
        while (i < vertices.length) {
            p = this.pointForVertex(vertices[i]);
            p = new Point2D.Double((p.getX() - minx) * bounds.getWidth() / (maxx - minx) + bounds.getX(), (p.getY() - miny) * bounds.getHeight() / (maxy - miny) + bounds.getY());
            this.moveVertex(vertices[i], p);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(super.toString()) + "\n");
        sb.append(this.verticesToPoints);
        return sb.toString();
    }
}

