/*
 * Decompiled with CFR 0.152.
 */
package automata.mealy;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.mealy.MealyConfiguration;
import automata.mealy.MealyTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class MealyStepByStateSimulator
extends AutomatonSimulator {
    public MealyStepByStateSimulator(Automaton automaton) {
        super(automaton);
    }

    public Configuration[] getInitialConfigurations(String input) {
        Configuration[] configs = new Configuration[]{new MealyConfiguration(this.myAutomaton.getInitialState(), null, input, input, "")};
        return configs;
    }

    public ArrayList stepConfiguration(Configuration configuration) {
        ArrayList<MealyConfiguration> list = new ArrayList<MealyConfiguration>();
        MealyConfiguration config = (MealyConfiguration)configuration;
        String unprocessedInput = config.getUnprocessedInput();
        String totalInput = config.getInput();
        State currentState = config.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int i = 0;
        while (i < transitions.length) {
            MealyTransition trans = (MealyTransition)transitions[i];
            String transLabel = trans.getLabel();
            if (unprocessedInput.startsWith(transLabel)) {
                String input = "";
                if (transLabel.length() < unprocessedInput.length()) {
                    input = unprocessedInput.substring(transLabel.length());
                }
                State toState = trans.getToState();
                String output = String.valueOf(config.getOutput()) + trans.getOutput();
                MealyConfiguration configToAdd = new MealyConfiguration(toState, config, totalInput, input, output);
                list.add(configToAdd);
            }
            ++i;
        }
        return list;
    }

    public boolean isAccepted() {
        Iterator it = this.myConfigurations.iterator();
        while (it.hasNext()) {
            MealyConfiguration config = (MealyConfiguration)it.next();
            if (!config.isAccept()) continue;
            return true;
        }
        return false;
    }

    public boolean simulateInput(String input) {
        this.myConfigurations.clear();
        Configuration[] initialConfigs = this.getInitialConfigurations(input);
        this.myConfigurations.addAll(Arrays.asList(initialConfigs));
        while (!this.myConfigurations.isEmpty()) {
            if (this.isAccepted()) {
                return true;
            }
            ArrayList configurationsToAdd = new ArrayList();
            Iterator it = this.myConfigurations.iterator();
            while (it.hasNext()) {
                MealyConfiguration config = (MealyConfiguration)it.next();
                configurationsToAdd.addAll(this.stepConfiguration(config));
                it.remove();
            }
            this.myConfigurations.addAll(configurationsToAdd);
        }
        return false;
    }
}

