/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.Automaton;
import automata.Configuration;
import automata.State;
import automata.pda.CharacterStack;

public class PDAConfiguration
extends Configuration {
    protected String myInput;
    protected String myUnprocessedInput;
    protected CharacterStack myStack;

    public PDAConfiguration(State state, PDAConfiguration parent, String input, String unprocessed, CharacterStack stack) {
        super(state, parent);
        this.myInput = input;
        this.myUnprocessedInput = unprocessed;
        this.myStack = stack;
    }

    public String getInput() {
        return this.myInput;
    }

    public String getUnprocessedInput() {
        return this.myUnprocessedInput;
    }

    public void setUnprocessedInput(String input) {
        this.myUnprocessedInput = input;
    }

    public CharacterStack getStack() {
        return this.myStack;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " INPUT: " + this.getUnprocessedInput() + " STACK: " + this.myStack.toString();
    }

    public boolean isAccept() {
        if (this.getUnprocessedInput().length() != 0) {
            return false;
        }
        State s = this.getCurrentState();
        Automaton a = s.getAutomaton();
        return a.isFinalState(s);
    }

    public boolean equals(Object configuration) {
        if (configuration == this) {
            return true;
        }
        try {
            return super.equals(configuration) && this.myUnprocessedInput.equals(((PDAConfiguration)configuration).myUnprocessedInput) && this.myStack.equals(((PDAConfiguration)configuration).myStack);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.myStack.hashCode() ^ this.myUnprocessedInput.hashCode();
    }
}

