/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.pda.CharacterStack;
import automata.pda.PDAConfiguration;
import automata.pda.PDATransition;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class PDAStepByStateSimulator
extends AutomatonSimulator {
    protected int myAcceptance = 1;
    protected static final int EMPTY_STACK = 0;
    protected static final int FINAL_STATE = 1;

    public PDAStepByStateSimulator(Automaton automaton) {
        super(automaton);
    }

    public Configuration[] getInitialConfigurations(String input) {
        Configuration[] configs = new Configuration[1];
        CharacterStack stack = new CharacterStack();
        stack.push("Z");
        configs[0] = new PDAConfiguration(this.myAutomaton.getInitialState(), null, input, input, stack);
        return configs;
    }

    public ArrayList stepConfiguration(Configuration config) {
        ArrayList<PDAConfiguration> list = new ArrayList<PDAConfiguration>();
        PDAConfiguration configuration = (PDAConfiguration)config;
        String unprocessedInput = configuration.getUnprocessedInput();
        String totalInput = configuration.getInput();
        State currentState = configuration.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int k = 0;
        while (k < transitions.length) {
            PDATransition transition = (PDATransition)transitions[k];
            String inputToRead = transition.getInputToRead();
            String stringToPop = transition.getStringToPop();
            CharacterStack tempStack = configuration.getStack();
            CharacterStack stack = new CharacterStack(tempStack);
            String stackContents = stack.pop(stringToPop.length());
            if (unprocessedInput.startsWith(inputToRead) && stringToPop.equals(stackContents)) {
                String input = "";
                if (inputToRead.length() < unprocessedInput.length()) {
                    input = unprocessedInput.substring(inputToRead.length());
                }
                State toState = transition.getToState();
                stack.push(transition.getStringToPush());
                PDAConfiguration configurationToAdd = new PDAConfiguration(toState, configuration, totalInput, input, stack);
                list.add(configurationToAdd);
            }
            ++k;
        }
        return list;
    }

    public void setAcceptByFinalState() {
        this.myAcceptance = 1;
    }

    public void setAcceptByEmptyStack() {
        this.myAcceptance = 0;
    }

    public boolean isAccepted() {
        Iterator it = this.myConfigurations.iterator();
        while (it.hasNext()) {
            PDAConfiguration configuration = (PDAConfiguration)it.next();
            if (this.myAcceptance == 1) {
                State currentState = configuration.getCurrentState();
                if (configuration.getUnprocessedInput() != "" || !this.myAutomaton.isFinalState(currentState)) continue;
                return true;
            }
            if (this.myAcceptance != 0) continue;
            CharacterStack stack = configuration.getStack();
            if (configuration.getUnprocessedInput() != "" || stack.height() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean simulateInput(String input) {
        this.myConfigurations.clear();
        Configuration[] initialConfigs = this.getInitialConfigurations(input);
        int k = 0;
        while (k < initialConfigs.length) {
            PDAConfiguration initialConfiguration = (PDAConfiguration)initialConfigs[k];
            this.myConfigurations.add(initialConfiguration);
            ++k;
        }
        int count = 0;
        while (!this.myConfigurations.isEmpty()) {
            if (this.isAccepted()) {
                return true;
            }
            ArrayList configurationsToAdd = new ArrayList();
            Iterator it = this.myConfigurations.iterator();
            while (it.hasNext()) {
                PDAConfiguration configuration = (PDAConfiguration)it.next();
                ArrayList configsToAdd = this.stepConfiguration(configuration);
                configurationsToAdd.addAll(configsToAdd);
                it.remove();
                if (++count <= 10000) continue;
                int result = JOptionPane.showConfirmDialog(null, "JFLAP has generated 10000 configurations. Continue?");
                switch (result) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        return false;
                    }
                }
            }
            this.myConfigurations.addAll(configurationsToAdd);
        }
        return false;
    }
}

