/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.Automaton;
import automata.ClosureTaker;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.pda.CharacterStack;
import automata.pda.PDAConfiguration;
import automata.pda.PDAStepByStateSimulator;
import automata.pda.PDATransition;
import java.util.ArrayList;

public class PDAStepWithClosureSimulator
extends PDAStepByStateSimulator {
    public PDAStepWithClosureSimulator(Automaton automaton) {
        super(automaton);
    }

    public Configuration[] getInitialConfigurations(String input) {
        State init = this.myAutomaton.getInitialState();
        State[] closure = ClosureTaker.getClosure(init, this.myAutomaton);
        Configuration[] configs = new Configuration[closure.length];
        int k = 0;
        while (k < closure.length) {
            CharacterStack stack = new CharacterStack();
            stack.push("Z");
            configs[k] = new PDAConfiguration(closure[k], null, input, input, stack);
            ++k;
        }
        return configs;
    }

    public ArrayList stepConfiguration(Configuration config) {
        ArrayList<PDAConfiguration> list = new ArrayList<PDAConfiguration>();
        PDAConfiguration configuration = (PDAConfiguration)config;
        String unprocessedInput = configuration.getUnprocessedInput();
        String totalInput = configuration.getInput();
        State currentState = configuration.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int k = 0;
        while (k < transitions.length) {
            PDATransition transition = (PDATransition)transitions[k];
            String inputToRead = transition.getInputToRead();
            String stringToPop = transition.getStringToPop();
            CharacterStack tempStack = configuration.getStack();
            CharacterStack stack = new CharacterStack(tempStack);
            String stackContents = stack.pop(stringToPop.length());
            if (unprocessedInput.startsWith(inputToRead) && stringToPop.equals(stackContents)) {
                String input = "";
                if (inputToRead.length() < unprocessedInput.length()) {
                    input = unprocessedInput.substring(inputToRead.length());
                }
                State toState = transition.getToState();
                stack.push(transition.getStringToPush());
                State[] closure = ClosureTaker.getClosure(toState, this.myAutomaton);
                int i = 0;
                while (i < closure.length) {
                    CharacterStack cstack = new CharacterStack(stack);
                    PDAConfiguration configurationToAdd = new PDAConfiguration(closure[i], configuration, totalInput, input, cstack);
                    list.add(configurationToAdd);
                    ++i;
                }
            }
            ++k;
        }
        return list;
    }
}

