/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import grammar.Production;
import grammar.cfg.ContextFreeGrammar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PDAToCFGConverter {
    protected static final String START_SYMBOL = "S";
    protected int UNIQUE_ID;
    protected HashMap MAP;
    protected static final String LEFT_PAREN = "(";
    protected static final String RIGHT_PAREN = ")";
    protected static final String BOTTOM_OF_STACK = "Z";

    public PDAToCFGConverter() {
        this.initializeConverter();
    }

    public void initializeConverter() {
        this.MAP = new HashMap();
        this.UNIQUE_ID = 0;
    }

    public boolean hasSingleFinalState(Automaton automaton) {
        State[] finalStates = automaton.getFinalStates();
        if (finalStates.length != 1) {
            return false;
        }
        State finalState = finalStates[0];
        Transition[] transitions = automaton.getTransitionsToState(finalState);
        int k = 0;
        while (k < transitions.length) {
            PDATransition trans = (PDATransition)transitions[k];
            String toPop = trans.getStringToPop();
            if (!toPop.substring(toPop.length() - 1).equals(BOTTOM_OF_STACK)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean hasTransitionsInCorrectForm(Automaton automaton) {
        Transition[] transitions = automaton.getTransitions();
        int k = 0;
        while (k < transitions.length) {
            if (!this.isPushLambdaTransition(transitions[k]) && !this.isPushTwoTransition(transitions[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public boolean isInCorrectFormForConversion(Automaton automaton) {
        return this.hasSingleFinalState(automaton) && this.hasTransitionsInCorrectForm(automaton);
    }

    public boolean isPushTwoTransition(Transition transition) {
        PDATransition trans = (PDATransition)transition;
        String toPush = trans.getStringToPush();
        if (toPush.length() != 2) {
            return false;
        }
        String toPop = trans.getStringToPop();
        return toPop.length() == 1;
    }

    public boolean isPushLambdaTransition(Transition transition) {
        PDATransition trans = (PDATransition)transition;
        String toPush = trans.getStringToPush();
        if (toPush.length() != 0) {
            return false;
        }
        String toPop = trans.getStringToPop();
        return toPop.length() == 1;
    }

    private String getUniqueVariable() {
        char[] ch = new char[]{(char)(65 + this.UNIQUE_ID)};
        ++this.UNIQUE_ID;
        if (65 + this.UNIQUE_ID == 83) {
            ++this.UNIQUE_ID;
        }
        return new String(ch);
    }

    public boolean isStartSymbol(String variable, Automaton automaton) {
        State startState = automaton.getInitialState();
        State[] finalStates = automaton.getFinalStates();
        if (finalStates.length > 1) {
            return false;
        }
        State finalState = finalStates[0];
        String startSymbol = LEFT_PAREN.concat(startState.getName().concat(BOTTOM_OF_STACK.concat(finalState.getName().concat(RIGHT_PAREN))));
        return variable.equals(startSymbol);
    }

    public ArrayList getProductionsForPushTwoTransition(Transition transition, Automaton automaton) {
        ArrayList<Production> list = new ArrayList<Production>();
        String fromState = transition.getFromState().getName();
        String toState = transition.getToState().getName();
        PDATransition trans = (PDATransition)transition;
        String toPop = trans.getStringToPop();
        String toRead = trans.getInputToRead();
        String toPush = trans.getStringToPush();
        String toPushOne = toPush.substring(0, 1);
        String toPushTwo = toPush.substring(1);
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            String state = states[k].getName();
            String lhs = LEFT_PAREN.concat(fromState.concat(toPop.concat(state.concat(RIGHT_PAREN))));
            int j = 0;
            while (j < states.length) {
                String lstate = states[j].getName();
                String variable1 = LEFT_PAREN.concat(toState.concat(toPushOne.concat(lstate.concat(RIGHT_PAREN))));
                String variable2 = LEFT_PAREN.concat(lstate.concat(toPushTwo.concat(state.concat(RIGHT_PAREN))));
                if (this.MAP.get(lhs) == null) {
                    if (this.isStartSymbol(lhs, automaton)) {
                        this.MAP.put(lhs, START_SYMBOL);
                    } else {
                        this.MAP.put(lhs, this.getUniqueVariable());
                    }
                }
                if (this.MAP.get(variable1) == null) {
                    if (this.isStartSymbol(variable1, automaton)) {
                        this.MAP.put(variable1, START_SYMBOL);
                    } else {
                        this.MAP.put(variable1, this.getUniqueVariable());
                    }
                }
                if (this.MAP.get(variable2) == null) {
                    if (this.isStartSymbol(variable2, automaton)) {
                        this.MAP.put(variable2, START_SYMBOL);
                    } else {
                        this.MAP.put(variable2, this.getUniqueVariable());
                    }
                }
                String rhs = toRead.concat(variable1.concat(variable2));
                Production p = new Production(lhs, rhs);
                list.add(p);
                ++j;
            }
            ++k;
        }
        return list;
    }

    public ArrayList getProductionsForPushLambdaTransition(Transition transition, Automaton automaton) {
        ArrayList<Production> list = new ArrayList<Production>();
        String fromState = transition.getFromState().getName();
        String toState = transition.getToState().getName();
        PDATransition trans = (PDATransition)transition;
        String toPop = trans.getStringToPop();
        String toRead = trans.getInputToRead();
        String lhs = LEFT_PAREN.concat(fromState.concat(toPop.concat(toState.concat(RIGHT_PAREN))));
        if (this.MAP.get(lhs) == null) {
            if (this.isStartSymbol(lhs, automaton)) {
                this.MAP.put(lhs, START_SYMBOL);
            } else {
                this.MAP.put(lhs, this.getUniqueVariable());
            }
        }
        String rhs = toRead;
        Production production = new Production(lhs, rhs);
        list.add(production);
        return list;
    }

    public ArrayList createProductionsForTransition(Transition transition, Automaton automaton) {
        ArrayList list = new ArrayList();
        if (this.isPushLambdaTransition(transition)) {
            list.addAll(this.getProductionsForPushLambdaTransition(transition, automaton));
        } else if (this.isPushTwoTransition(transition)) {
            list.addAll(this.getProductionsForPushTwoTransition(transition, automaton));
        }
        return list;
    }

    public Production getSimplifiedProduction(Production production) {
        int rightIndex;
        int leftIndex;
        String lhs = (String)this.MAP.get(production.getLHS());
        String rhs = production.getRHS();
        StringBuffer newRhs = new StringBuffer();
        while ((leftIndex = rhs.indexOf(40)) != -1 && (rightIndex = rhs.indexOf(41)) != -1) {
            newRhs.append(rhs.substring(0, leftIndex));
            String variable = rhs.substring(leftIndex, rightIndex + 1);
            newRhs.append(this.MAP.get(variable));
            rhs = rhs.substring(rightIndex + 1);
        }
        newRhs.append(rhs);
        Production p = new Production(lhs, newRhs.toString());
        return p;
    }

    public int numberVariables() {
        return new HashSet(this.MAP.values()).size();
    }

    public ContextFreeGrammar convertToContextFreeGrammar(Automaton automaton) {
        if (!(automaton instanceof PushdownAutomaton)) {
            throw new IllegalArgumentException("automaton must be PushdownAutomaton");
        }
        if (!this.isInCorrectFormForConversion(automaton)) {
            throw new IllegalArgumentException("automaton not in correct form for conversion to CFG");
        }
        this.initializeConverter();
        ArrayList list = new ArrayList();
        ContextFreeGrammar grammar = new ContextFreeGrammar();
        Transition[] transitions = automaton.getTransitions();
        int k = 0;
        while (k < transitions.length) {
            list.addAll(this.createProductionsForTransition(transitions[k], automaton));
            ++k;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Production p = (Production)it.next();
            grammar.addProduction(this.getSimplifiedProduction(p));
        }
        return grammar;
    }
}

