/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Automaton;
import automata.Configuration;
import automata.State;
import automata.turing.Tape;
import java.util.Stack;

public class TMConfiguration
extends Configuration
implements Cloneable {
    protected Tape[] myTapes;

    public TMConfiguration(State state, TMConfiguration parent, Tape[] tapes) {
        super(state, parent);
        this.myTapes = tapes;
    }

    public Tape[] getTapes() {
        return this.myTapes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        int i = 0;
        while (i < this.myTapes.length) {
            sb.append(" TAPE ");
            sb.append(i);
            sb.append(": ");
            sb.append(this.myTapes[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public boolean isAccept() {
        State s = this.getCurrentState();
        if (s == null) {
            return false;
        }
        boolean bottom = false;
        boolean top = false;
        Stack parentAutosClone = (Stack)this.getAutoStack().clone();
        Stack parentBlocksClone = (Stack)this.getBlockStack().clone();
        if (!s.getFinalStateInBlock() && parentAutosClone.size() == 1) {
            State[] finals = ((Automaton)parentAutosClone.firstElement()).getFinalStates();
            int m = 0;
            while (m < finals.length) {
                if (finals[m] == s) {
                    return true;
                }
                ++m;
            }
            return false;
        }
        boolean finalState = true;
        parentBlocksClone.push(s);
        int count = 0;
        while (parentAutosClone.size() > 0) {
            finalState = this.isFinalStateInAutomaton((Automaton)parentAutosClone.pop(), (State)parentBlocksClone.pop());
            if (!finalState) {
                return false;
            }
            ++count;
        }
        return true;
    }

    private boolean isFinalStateInAutomaton(Automaton auto, State state) {
        State[] finals = auto.getFinalStates();
        int m = 0;
        while (m < finals.length) {
            if (finals[m] == state) {
                return true;
            }
            ++m;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object configuration) {
        if (configuration == this) {
            return true;
        }
        try {
            if (!super.equals(configuration)) {
                return false;
            }
            Tape[] tapes = ((TMConfiguration)configuration).myTapes;
            if (tapes.length != this.myTapes.length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= tapes.length) {
                    return true;
                }
                if (!tapes[i].equals(this.myTapes[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        int code = super.hashCode();
        int i = 0;
        while (i < this.myTapes.length) {
            code ^= this.myTapes[i].hashCode();
            ++i;
        }
        return code;
    }

    public Object clone() {
        TMConfiguration newConfig = new TMConfiguration(this.getCurrentState(), (TMConfiguration)this.getParent(), this.myTapes);
        newConfig.setAutoStack((Stack)this.getAutoStack().clone());
        newConfig.setBlockStack((Stack)this.getBlockStack().clone());
        newConfig.setFocused(this.getFocused());
        return newConfig;
    }
}

