/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.turing.TMConfiguration;
import automata.turing.TMTransition;
import automata.turing.Tape;
import automata.turing.TuringMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class TMSimulator
extends AutomatonSimulator {
    private String[] inputStrings;
    private Map varToChar = new HashMap();

    public TMSimulator(Automaton automaton) {
        super(automaton);
        if (!(automaton instanceof TuringMachine)) {
            throw new IllegalArgumentException("Automaton is not a Turing machine, but a " + automaton.getClass());
        }
    }

    public Configuration[] getInitialConfigurations(String input) {
        int tapes = ((TuringMachine)this.myAutomaton).tapes();
        String[] inputs = new String[tapes];
        int i = 0;
        while (i < tapes) {
            inputs[i] = input;
            ++i;
        }
        return this.getInitialConfigurations(inputs);
    }

    public Configuration[] getInitialConfigurations(String[] inputs) {
        this.inputStrings = (String[])inputs.clone();
        Tape[] tapes = new Tape[inputs.length];
        int i = 0;
        while (i < tapes.length) {
            tapes[i] = new Tape(inputs[i]);
            ++i;
        }
        Configuration[] configs = new Configuration[1];
        State initialState = this.myAutomaton.getInitialState();
        Automaton top = (Automaton)this.myAutomaton.getBlockMap().get(initialState.getInternalName());
        Stack<Automaton> initialAutos = new Stack<Automaton>();
        initialAutos.push(this.myAutomaton);
        Stack<State> initialBlocks = new Stack<State>();
        while (top != null) {
            initialBlocks.push(initialState);
            initialAutos.push(top);
            initialState = top.getInitialState();
            top = (Automaton)top.getBlockMap().get(initialState.getInternalName());
        }
        configs[0] = new TMConfiguration(initialState, null, tapes);
        configs[0].setAutoStack(initialAutos);
        configs[0].setBlockStack(initialBlocks);
        return configs;
    }

    private boolean isFinalStateInAutomaton(Automaton auto, State state) {
        State[] finals = auto.getFinalStates();
        int m = 0;
        while (m < finals.length) {
            if (finals[m] == state) {
                return true;
            }
            ++m;
        }
        return false;
    }

    public ArrayList stepConfiguration(Configuration config) {
        Stack parentAutos = config.getAutoStack();
        Stack parentBlocks = config.getBlockStack();
        ArrayList<TMConfiguration> list = new ArrayList<TMConfiguration>();
        TMConfiguration configuration = (TMConfiguration)config;
        State currentState = configuration.getCurrentState();
        Transition[] transitions = new Transition[50];
        if (!currentState.getFinalStateInBlock()) {
            transitions = ((Automaton)parentAutos.peek()).getTransitionsFromState(currentState);
        } else {
            parentBlocks.push(currentState);
            while (this.isFinalStateInAutomaton((Automaton)parentAutos.peek(), (State)parentBlocks.peek())) {
                if (parentAutos.size() > 1) {
                    parentAutos.pop();
                }
                if (parentBlocks.size() > 1) {
                    parentBlocks.pop();
                }
                transitions = ((Automaton)parentAutos.peek()).getTransitionsFromState((State)parentBlocks.peek());
                currentState = (State)parentBlocks.peek();
            }
            if (parentBlocks.size() >= 1) {
                parentBlocks.pop();
            }
        }
        int k = 0;
        while (k < transitions.length) {
            Stack parentAutosClone = (Stack)parentAutos.clone();
            Stack parentBlocksClone = (Stack)parentBlocks.clone();
            TMTransition t = (TMTransition)transitions[k];
            Tape[] tapes = configuration.getTapes();
            boolean okay = true;
            int i = 0;
            while (okay && i < tapes.length) {
                String charAtHead = tapes[i].read();
                String toRead = t.getRead(i);
                int index = toRead.indexOf("}");
                if (!charAtHead.equals(toRead) && !toRead.equals("~")) {
                    if (toRead.startsWith("!")) {
                        if (toRead.indexOf(charAtHead) != -1) {
                            okay = false;
                        }
                    } else if (index != -1) {
                        String postBracket = toRead.substring(index);
                        while (postBracket.startsWith(" ") || postBracket.startsWith("}")) {
                            postBracket = postBracket.substring(1);
                        }
                        while (postBracket.endsWith(" ")) {
                            postBracket = postBracket.substring(0, postBracket.length() - 1);
                        }
                        String preBracket = toRead.substring(0, index);
                        if (preBracket.indexOf(charAtHead) == -1) {
                            okay = false;
                        } else {
                            this.varToChar.put(postBracket, charAtHead);
                        }
                    } else if (this.varToChar.get(toRead) != null) {
                        if (!this.varToChar.get(toRead).equals(charAtHead)) {
                            okay = false;
                        }
                    } else {
                        okay = false;
                    }
                }
                ++i;
            }
            if (okay) {
                State toState = t.getToState();
                if (toState.getInternalName() != null) {
                    parentBlocksClone.push(toState);
                    Automaton autoParent = (Automaton)((Automaton)parentAutosClone.peek()).getBlockMap().get(toState.getInternalName());
                    parentAutosClone.push(autoParent);
                    toState = autoParent.getInitialState();
                } else if (toState.getParentBlock() != null) {
                    toState.setParentBlock((State)parentBlocksClone.peek());
                }
                Tape[] tapes2 = new Tape[tapes.length];
                int i2 = 0;
                while (i2 < tapes.length) {
                    tapes2[i2] = new Tape(tapes[i2]);
                    String toWrite = t.getWrite(i2);
                    String var = (String)this.varToChar.get(toWrite);
                    if (var != null) {
                        toWrite = var;
                    }
                    if (!toWrite.equals("~")) {
                        tapes2[i2].write(toWrite);
                    }
                    String direction = t.getDirection(i2);
                    tapes2[i2].moveHead(direction);
                    ++i2;
                }
                TMConfiguration configurationToAdd = new TMConfiguration(toState, configuration, tapes2);
                configurationToAdd.setAutoStack(parentAutosClone);
                configurationToAdd.setBlockStack(parentBlocksClone);
                list.add(configurationToAdd);
            }
            ++k;
        }
        return list;
    }

    public boolean isAccepted() {
        Iterator it = this.myConfigurations.iterator();
        while (it.hasNext()) {
            TMConfiguration configuration = (TMConfiguration)it.next();
            State currentState = configuration.getCurrentState();
            if (this.myAutomaton.isFinalState(currentState)) {
                return true;
            }
            Stack parentAutosClone = (Stack)configuration.getAutoStack().clone();
            Stack parentBlocksClone = (Stack)configuration.getBlockStack().clone();
            while (parentBlocksClone.size() > 0) {
                State up = (State)parentBlocksClone.pop();
                if (up.getFinalStateInBlock()) continue;
                return false;
            }
        }
        return false;
    }

    public boolean simulateInput(String input) {
        this.myConfigurations.clear();
        Configuration[] initialConfigs = this.getInitialConfigurations(input);
        int k = 0;
        while (k < initialConfigs.length) {
            TMConfiguration initialConfiguration = (TMConfiguration)initialConfigs[k];
            this.myConfigurations.add(initialConfiguration);
            ++k;
        }
        while (!this.myConfigurations.isEmpty()) {
            if (this.isAccepted()) {
                return true;
            }
            ArrayList configurationsToAdd = new ArrayList();
            Iterator it = this.myConfigurations.iterator();
            while (it.hasNext()) {
                TMConfiguration configuration = (TMConfiguration)it.next();
                ArrayList configsToAdd = this.stepConfiguration(configuration);
                configurationsToAdd.addAll(configsToAdd);
                it.remove();
            }
            this.myConfigurations.addAll(configurationsToAdd);
        }
        return false;
    }

    public String[] getInputStrings() {
        return this.inputStrings;
    }
}

