/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Codec;
import file.Encoder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CodecRegistry {
    private List encoders = new ArrayList();
    private List decoders = new ArrayList();

    public void add(Codec codec) {
        this.addEncoder(codec);
        this.addDecoder(codec);
    }

    private void addEncoder(Encoder encoder) {
        this.encoders.add(encoder);
    }

    private void addDecoder(Encoder decoder) {
        this.decoders.add(decoder);
    }

    public List getEncoders(Serializable structure) {
        if (structure == null) {
            return Collections.unmodifiableList(this.encoders);
        }
        ArrayList<Codec> validEncoders = new ArrayList<Codec>();
        Iterator it = this.encoders.iterator();
        while (it.hasNext()) {
            Codec enc = (Codec)it.next();
            if (!enc.canEncode(structure)) continue;
            validEncoders.add(enc);
        }
        return Collections.unmodifiableList(validEncoders);
    }

    public List getDecoders() {
        return Collections.unmodifiableList(this.decoders);
    }
}

