/*
 * Decompiled with CFR 0.152.
 */
package file;

import automata.Automaton;
import automata.State;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import automata.turing.TMTransition;
import automata.turing.TuringMachine;
import file.Codec;
import file.ParseException;
import grammar.Grammar;
import grammar.Production;
import grammar.UnboundGrammar;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import regular.RegularExpression;

public class JFLAP3Codec
extends Codec {
    public static final String FINITE_AUTOMATON_SUFFIX = ".FA";
    public static final String PUSHDOWN_AUTOMATON_SUFFIX = ".PDA";
    public static final String TURING_MACHINE_SUFFIX = ".TM";
    public static final String TWO_TAPE_TURING_MACHINE_SUFFIX = ".TTM";
    public static final String GRAMMAR_SUFFIX = ".GRM";
    public static final String REGULAR_EXPRESSION_SUFFIX = ".REX";
    private static final String FINITE_AUTOMATON_CODE = "One-Way-FSA";
    private static final String PUSHDOWN_AUTOMATON_CODE = "PDAP";
    private static final String TURING_MACHINE_CODE = "REGTM";

    public Serializable decode(File file, Map parameters) {
        if (file.getName().endsWith(GRAMMAR_SUFFIX)) {
            return this.readGrammar(file);
        }
        if (file.getName().endsWith(REGULAR_EXPRESSION_SUFFIX)) {
            return this.readRE(file);
        }
        return this.readAutomaton(file);
    }

    private RegularExpression readRE(File file) {
        String rstring = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                rstring = line;
            }
        }
        catch (FileNotFoundException e) {
            throw new ParseException("Could not find file " + file.getName() + "!");
        }
        catch (IOException e) {
            throw new ParseException("Error accessing file to write!");
        }
        return new RegularExpression(rstring);
    }

    private Grammar readGrammar(File file) {
        UnboundGrammar g = new UnboundGrammar();
        int lineNum = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                ++lineNum;
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] elems = line.split("\\s+");
                int len = elems.length;
                if (len > 3 || len < 2 || !elems[1].equals("->")) {
                    throw new ParseException("Line " + lineNum + " is not formatted properly!");
                }
                g.addProduction(new Production(elems[0], len == 3 ? elems[2] : ""));
            }
        }
        catch (FileNotFoundException e) {
            throw new ParseException("Could not find file " + file.getName() + "!");
        }
        catch (IOException e) {
            throw new ParseException("Error accessing file to write!");
        }
        return g;
    }

    private Automaton readAutomaton(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine().trim();
            if (line.equals(FINITE_AUTOMATON_CODE)) {
                return this.readFA(reader);
            }
            if (line.equals(PUSHDOWN_AUTOMATON_CODE)) {
                return this.readPDA(reader);
            }
            if (line.equals(TURING_MACHINE_CODE)) {
                return this.readTM(reader);
            }
            throw new ParseException("Unknown machine type " + line + "!");
        }
        catch (NullPointerException e) {
            throw new ParseException("Unexpected end of file!");
        }
        catch (FileNotFoundException e) {
            throw new ParseException("Could not find file " + file.getName() + "!");
        }
        catch (IOException e) {
            throw new ParseException("Error accessing file to write!");
        }
    }

    private FiniteStateAutomaton readFA(BufferedReader reader) throws IOException {
        FiniteStateAutomaton fa = new FiniteStateAutomaton();
        State[] states = this.readStateCreate(fa, reader);
        String[][][] groups = this.readTransitionGroups(2, 1, states.length, reader);
        int s = 0;
        while (s < groups.length) {
            int g = 0;
            while (g < groups[s].length) {
                String[] group = groups[s][g];
                State to = states[Integer.parseInt(group[1]) - 1];
                State from = states[s];
                if (group[0].equals("null")) {
                    group[0] = "";
                }
                FSATransition t = new FSATransition(from, to, group[0]);
                fa.addTransition(t);
                ++g;
            }
            ++s;
        }
        this.readStateMove(states, reader);
        return fa;
    }

    private PushdownAutomaton readPDA(BufferedReader reader) throws IOException {
        String ender = reader.readLine().trim();
        if (!(ender.equals("FINAL") || ender.equals("EMPTY") || ender.equals("FINAL+EMPTY"))) {
            throw new ParseException(String.valueOf(ender) + " is a bad finishing type for PDA!");
        }
        PushdownAutomaton pda = new PushdownAutomaton();
        State[] states = this.readStateCreate(pda, reader);
        String[][][] groups = this.readTransitionGroups(5, 3, states.length, reader);
        int s = 0;
        while (s < groups.length) {
            int g = 0;
            while (g < groups[s].length) {
                String[] group = groups[s][g];
                State to = states[Integer.parseInt(group[3]) - 1];
                State from = states[s];
                try {
                    int[] nArray = new int[3];
                    nArray[1] = 1;
                    nArray[2] = 4;
                    int[] check = nArray;
                    int i = 0;
                    while (i < check.length) {
                        if (group[check[i]].equals("null")) {
                            group[check[i]] = "";
                        }
                        ++i;
                    }
                    PDATransition t = new PDATransition(from, to, group[0], group[1], group[4]);
                    pda.addTransition(t);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getMessage());
                }
                ++g;
            }
            ++s;
        }
        this.readStateMove(states, reader);
        return pda;
    }

    private TuringMachine readTM(BufferedReader reader) throws IOException {
        if (!reader.readLine().trim().equals("TAPE")) {
            throw new ParseException("Expected TAPE line absent!");
        }
        int tapes = 0;
        try {
            tapes = Integer.parseInt(reader.readLine());
            if (tapes != 1 && tapes != 2) {
                throw new ParseException("May only have 1 or 2 tapes!");
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Bad format for number of tapes!");
        }
        TuringMachine tm = new TuringMachine(tapes);
        State[] states = this.readStateCreate(tm, reader);
        String[][][] groups = this.readTransitionGroups(1 + 3 * tm.tapes(), 1, states.length, reader);
        int s = 0;
        while (s < groups.length) {
            int g = 0;
            while (g < groups[s].length) {
                String[] group = groups[s][g];
                State to = states[Integer.parseInt(group[1]) - 1];
                State from = states[s];
                try {
                    int[] nArray;
                    if (tm.tapes() == 1) {
                        int[] nArray2 = new int[2];
                        nArray = nArray2;
                        nArray2[1] = 2;
                    } else {
                        int[] nArray3 = new int[4];
                        nArray3[1] = 2;
                        nArray3[2] = 4;
                        nArray = nArray3;
                        nArray3[3] = 5;
                    }
                    int[] check = nArray;
                    int i = 0;
                    while (i < check.length) {
                        if (group[check[i]].equals("B")) {
                            group[check[i]] = "";
                        }
                        ++i;
                    }
                    TMTransition t = tm.tapes() == 1 ? new TMTransition(from, to, group[0], group[2], group[3].toUpperCase()) : new TMTransition(from, to, new String[]{group[0], group[4]}, new String[]{group[2], group[5]}, new String[]{group[3].toUpperCase(), group[6].toUpperCase()});
                    tm.addTransition(t);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getMessage());
                }
                ++g;
            }
            ++s;
        }
        this.readStateMove(states, reader);
        return tm;
    }

    private State[] readStateCreate(Automaton automaton, BufferedReader reader) throws IOException {
        State[] states = null;
        try {
            int numStates = Integer.parseInt(reader.readLine());
            if (numStates < 0) {
                throw new ParseException("Number of states cannot be " + numStates + "!");
            }
            states = new State[numStates];
        }
        catch (NumberFormatException e) {
            throw new ParseException("Bad format for number of states!");
        }
        int i = 0;
        while (i < states.length) {
            states[i] = automaton.createState(new Point(0, 0));
            ++i;
        }
        reader.readLine();
        if (!(automaton instanceof FiniteStateAutomaton)) {
            reader.readLine();
        }
        try {
            int initStateID = Integer.parseInt(reader.readLine());
            if (initStateID < 1 || initStateID > states.length) {
                throw new ParseException("Initial state cannot be " + initStateID + ".");
            }
            automaton.setInitialState(states[initStateID - 1]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Bad format for initial state ID!");
        }
        String line = reader.readLine();
        String[] lineTokens = line.split("\\s+");
        if (lineTokens.length == 0) {
            throw new ParseException("Final state list is empty line!");
        }
        try {
            int last = Integer.parseInt(lineTokens[lineTokens.length - 1]);
            if (last != 0) {
                throw new ParseException("Final state list not terminated with 0!");
            }
            try {
                int i2 = 0;
                while (i2 < lineTokens.length - 1) {
                    automaton.addFinalState(states[Integer.parseInt(lineTokens[i2]) - 1]);
                    ++i2;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParseException("Bad final state ID read!");
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Bad format in final state list!");
        }
        return states;
    }

    private void readStateMove(State[] states, BufferedReader reader) throws IOException {
        int i = 0;
        while (i < states.length) {
            int y;
            int x;
            String[] tokens = reader.readLine().split("\\s+");
            try {
                x = Integer.parseInt(tokens[1]);
                y = Integer.parseInt(tokens[2]);
            }
            catch (NumberFormatException e) {
                throw new ParseException("State " + (i + 1) + "'s position badly formatted.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ParseException("State " + (i + 1) + "'s position string too short.");
            }
            states[i].getPoint().setLocation(x, y);
            ++i;
        }
    }

    private String[][][] readTransitionGroups(int groupSize, int idPosition, int numStates, BufferedReader reader) throws IOException {
        String[][][] groups = new String[numStates][][];
        int s = 0;
        while (s < numStates) {
            ParseException p = new ParseException("Transition line " + (s + 1) + " badly formatted.");
            String[] tokens = reader.readLine().split("\\s+");
            if (tokens.length % groupSize != 1 || !tokens[tokens.length - 1].equals("EOL")) {
                throw p;
            }
            groups[s] = new String[tokens.length / groupSize][];
            int g = 0;
            while (g < groups[s].length) {
                groups[s][g] = new String[groupSize];
                int i = 0;
                while (i < groupSize) {
                    groups[s][g][i] = tokens[groupSize * g + i];
                    ++i;
                }
                try {
                    i = Integer.parseInt(groups[s][g][idPosition]);
                    if (i < 1 || i > numStates) {
                        throw p;
                    }
                }
                catch (NumberFormatException e) {
                    throw p;
                }
                ++g;
            }
            ++s;
        }
        return groups;
    }

    public File encode(Serializable structure, File file, Map parameters) {
        return file;
    }

    public boolean canEncode(Serializable structure) {
        return false;
    }

    public String getDescription() {
        return "JFLAP 3 File";
    }
}

