/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Codec;
import file.EncodeException;
import file.ParseException;
import file.xml.DOMPrettier;
import file.xml.Transducer;
import file.xml.TransducerFactory;
import gui.pumping.PumpingLemmaChooser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLCodec
extends Codec {
    public static final String SUFFIX = ".jff";

    public Serializable decode(File file, Map parameters) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            Transducer transducer = TransducerFactory.getTransducer(doc);
            return transducer.fromDOM(doc);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("Java could not create the parser!");
        }
        catch (IOException e) {
            throw new ParseException("Could not open file to read!");
        }
        catch (SAXException e) {
            throw new ParseException("Could not parse XML!\n" + e.getMessage());
        }
        catch (ExceptionInInitializerError e) {
            System.err.println("STATIC INIT:");
            e.getException().printStackTrace();
            throw new ParseException("Unexpected Error!");
        }
    }

    public File encode(Serializable structure, File file, Map parameters) {
        Transducer transducer = null;
        try {
            transducer = TransducerFactory.getTransducer(structure);
            Document dom = structure instanceof PumpingLemmaChooser ? transducer.toDOM(((PumpingLemmaChooser)structure).getCurrent()) : transducer.toDOM(structure);
            DOMPrettier.makePretty(dom);
            DOMSource s = new DOMSource(dom);
            StreamResult r = new StreamResult(file);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(s, r);
            return file;
        }
        catch (IllegalArgumentException e) {
            throw new EncodeException("No XML transducer available for this structure!");
        }
        catch (TransformerConfigurationException e) {
            throw new EncodeException("Could not open file to write!");
        }
        catch (TransformerException e) {
            throw new EncodeException("Could not open file to write!");
        }
    }

    public boolean canEncode(Serializable structure) {
        return true;
    }

    public String getDescription() {
        return "JFLAP 4 File";
    }

    public String proposeFilename(String filename, Serializable structure) {
        if (!filename.endsWith(SUFFIX)) {
            return String.valueOf(filename) + SUFFIX;
        }
        return filename;
    }
}

