/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.Transition;
import automata.graph.AutomatonGraph;
import automata.graph.GEMLayoutAlgorithm;
import automata.mealy.MooreMachine;
import file.DataException;
import file.xml.AbstractTransducer;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AutomatonTransducer
extends AbstractTransducer {
    private Map automatonMap = new HashMap();
    private Automaton originalAutomaton = null;
    private static final String AUTOMATON_NAME = "automaton";
    private static final String COMMENT_AUTOMATA = "The list of automata";
    private static final String FILE_NAME = "tag";
    public static final String BLOCK_NAME = "block";
    public static final String STATE_NAME = "state";
    public static final String STATE_ID_NAME = "id";
    public static final String STATE_X_COORD_NAME = "x";
    public static final String STATE_Y_COORD_NAME = "y";
    public static final String STATE_LABEL_NAME = "label";
    public static final String STATE_NAME_NAME = "name";
    public static final String STATE_FINAL_NAME = "final";
    public static final String STATE_INITIAL_NAME = "initial";
    public static final String TRANSITION_NAME = "transition";
    public static final String TRANSITION_FROM_NAME = "from";
    public static final String TRANSITION_TO_NAME = "to";
    private static final String COMMENT_STATES = "The list of states.";
    private static final String COMMENT_TRANSITIONS = "The list of transitions.";
    public static final String NOTE_NAME = "note";
    public static final String NOTE_TEXT_NAME = "text";
    private static final String IS_BLOCK = "block";

    protected abstract Automaton createEmptyAutomaton(Document var1);

    protected Map readStates(Node node, Automaton automaton, Set locatedStates, Document document) {
        HashMap i2s = new HashMap();
        if (node == null) {
            return i2s;
        }
        NodeList allNodes = node.getChildNodes();
        ArrayList<Node> stateNodes = new ArrayList<Node>();
        int k = 0;
        while (k < allNodes.getLength()) {
            if (allNodes.item(k).getNodeName().equals(STATE_NAME)) {
                stateNodes.add(allNodes.item(k));
            }
            ++k;
        }
        TreeMap i2sn = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Integer && !(o2 instanceof Integer)) {
                    return -1;
                }
                if (o1 instanceof Integer) {
                    return (Integer)o1 - (Integer)o2;
                }
                if (o2 instanceof Integer) {
                    return 1;
                }
                return ((Comparable)o1).compareTo(o2);
            }
        });
        this.createState(stateNodes, i2sn, automaton, locatedStates, i2s, false, document);
        return i2s;
    }

    protected void createState(ArrayList stateNodes, Map i2sn, Automaton automaton, Set locatedStates, Map i2s, boolean isBlock, Document document) {
        int i = 0;
        while (i < stateNodes.size()) {
            Node stateNode = (Node)stateNodes.get(i);
            if (stateNode.getNodeType() == 1) {
                String idString = ((Element)stateNode).getAttribute(STATE_ID_NAME);
                if (idString == null) {
                    throw new DataException("State without id attribute encountered!");
                }
                Integer id = AutomatonTransducer.parseID(idString);
                if (i2sn.put(id, stateNode) != null) {
                    throw new DataException("The state ID " + id + " appears twice!");
                }
            }
            ++i;
        }
        Iterator it = i2sn.keySet().iterator();
        while (it.hasNext()) {
            Integer id = (Integer)it.next();
            Element stateNode = (Element)i2sn.get(id);
            Map e2t = AutomatonTransducer.elementsToText(stateNode);
            Point p = new Point();
            boolean hasLocation = true;
            double x = 0.0;
            double y = 0.0;
            try {
                x = Double.parseDouble(e2t.get(STATE_X_COORD_NAME).toString());
            }
            catch (NullPointerException e) {
                hasLocation = false;
            }
            catch (NumberFormatException e) {
                throw new DataException("The x coordinate " + e2t.get(STATE_X_COORD_NAME) + " could not be read for state " + id + ".");
            }
            try {
                y = Double.parseDouble(e2t.get(STATE_Y_COORD_NAME).toString());
            }
            catch (NullPointerException e) {
                hasLocation = false;
            }
            catch (NumberFormatException e) {
                throw new DataException("The y coordinate " + e2t.get(STATE_Y_COORD_NAME) + " could not be read for state " + id + ".");
            }
            p.setLocation(x, y);
            State state = null;
            if (!isBlock) {
                state = automaton.createStateWithId(p, id);
            } else {
                String fileName = e2t.get(FILE_NAME).toString();
                Node tempNode = document.getDocumentElement().getElementsByTagName(fileName).item(0);
                Automaton temp = (Automaton)this.readAutomaton(tempNode, document);
                state = automaton.createBlockFromAutomaton(p, temp, fileName, id);
            }
            if (hasLocation && locatedStates != null) {
                locatedStates.add(state);
            }
            i2s.put(id, state);
            String name = stateNode.getAttribute(STATE_NAME_NAME);
            if (name.equals("")) {
                state.setName("q" + id);
            } else {
                state.setName(name);
            }
            if (e2t.containsKey(STATE_NAME_NAME)) {
                state.setName((String)e2t.get(STATE_NAME_NAME));
            }
            if (e2t.containsKey(STATE_LABEL_NAME)) {
                state.setLabel((String)e2t.get(STATE_LABEL_NAME));
            }
            if (e2t.containsKey(STATE_FINAL_NAME)) {
                automaton.addFinalState(state);
            }
            if (e2t.containsKey(STATE_INITIAL_NAME)) {
                automaton.setInitialState(state);
            }
            if (!(automaton instanceof MooreMachine) || !e2t.containsKey("output")) continue;
            ((MooreMachine)automaton).setOutput(state, (String)e2t.get("output"));
        }
    }

    protected void addBlocks(Node node, Automaton automaton, Set locatedStates, Map i2s, Document document) {
        if (node == null) {
            return;
        }
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList allNodes = node.getChildNodes();
        ArrayList<Node> blockNodes = new ArrayList<Node>();
        int k = 0;
        while (k < allNodes.getLength()) {
            if (allNodes.item(k).getNodeName().equals("block")) {
                blockNodes.add(allNodes.item(k));
            }
            ++k;
        }
        TreeMap i2sn = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Integer && !(o2 instanceof Integer)) {
                    return -1;
                }
                if (o1 instanceof Integer) {
                    return (Integer)o1 - (Integer)o2;
                }
                if (o2 instanceof Integer) {
                    return 1;
                }
                return ((Comparable)o1).compareTo(o2);
            }
        });
        this.createState(blockNodes, i2sn, automaton, locatedStates, i2s, true, document);
    }

    protected abstract Transition createTransition(State var1, State var2, Node var3, Map var4, boolean var5);

    protected void readTransitions(Node parent, Automaton automaton, Map id2state) {
        HashMap i2s = new HashMap();
        if (parent == null || automaton == null) {
            return;
        }
        NodeList allNodes = parent.getChildNodes();
        ArrayList<Node> tNodes = new ArrayList<Node>();
        boolean bool = false;
        int k = 0;
        while (k < allNodes.getLength()) {
            if (allNodes.item(k).getNodeName().equals(TRANSITION_NAME)) {
                tNodes.add(allNodes.item(k));
            }
            ++k;
        }
        int i = 0;
        while (i < tNodes.size()) {
            String fromName;
            Node tNode = (Node)tNodes.get(i);
            Map e2t = AutomatonTransducer.elementsToText(tNode);
            String isBlock = ((Element)tNode).getAttribute("block");
            if (isBlock.equals("true")) {
                bool = true;
            }
            if ((fromName = (String)e2t.get(TRANSITION_FROM_NAME)) == null) {
                throw new DataException("A transition has no from state!");
            }
            int id = AutomatonTransducer.parseID(fromName);
            State from = automaton.getStateWithID(id);
            if (from == null) {
                throw new DataException("A transition is defined from non-existent state " + id + "!");
            }
            String toName = (String)e2t.get(TRANSITION_TO_NAME);
            if (toName == null) {
                throw new DataException("A transition has no to state!");
            }
            id = AutomatonTransducer.parseID(toName);
            State to = automaton.getStateWithID(id);
            if (to == null) {
                throw new DataException("A transition is defined to non-existent state " + id + "!");
            }
            Transition transition = this.createTransition(from, to, tNode, e2t, bool);
            automaton.addTransition(transition);
            bool = false;
            ++i;
        }
    }

    protected static Integer parseID(String string) {
        try {
            int num = Integer.parseInt(string);
            return new Integer(num);
        }
        catch (NumberFormatException e) {
            return new Integer(-1);
        }
    }

    private void performLayout(Automaton automaton, Set locStates) {
        if (locStates.size() == automaton.getStates().length) {
            return;
        }
        AutomatonGraph graph = new AutomatonGraph(automaton);
        GEMLayoutAlgorithm layout = new GEMLayoutAlgorithm();
        int i = 0;
        while (i < 3) {
            layout.layout(graph, locStates);
            ++i;
        }
        if (locStates.size() < 2) {
            graph.moveWithinFrame(new Rectangle(20, 20, 425, 260));
        }
        graph.moveAutomatonStates();
    }

    public Serializable fromDOM(Document document) {
        this.automatonMap.clear();
        Automaton a = this.createEmptyAutomaton(document);
        Node parent = document.getDocumentElement().getElementsByTagName(AUTOMATON_NAME).item(0);
        if (parent == null) {
            parent = document.getDocumentElement();
        }
        return this.readAutomaton(parent, document);
    }

    public Serializable readAutomaton(Node parent, Document document) {
        HashSet locatedStates = new HashSet();
        Automaton root = this.createEmptyAutomaton(document);
        if (parent == null) {
            return root;
        }
        this.readBlocks(parent, root, locatedStates, document);
        this.readTransitions(parent, root, this.readStates(parent, root, locatedStates, document));
        this.readnotes(parent, root, document);
        this.performLayout(root, locatedStates);
        this.automatonMap.put(parent.getNodeName(), root);
        return root;
    }

    private void readnotes(Node parent, Automaton root, Document document) {
        NodeList allNodes = parent.getChildNodes();
        ArrayList<Node> noteNodes = new ArrayList<Node>();
        int k = 0;
        while (k < allNodes.getLength()) {
            if (allNodes.item(k).getNodeName().equals(NOTE_NAME)) {
                noteNodes.add(allNodes.item(k));
            }
            ++k;
        }
        int i = 0;
        while (i < noteNodes.size()) {
            Node noteNode = (Node)noteNodes.get(i);
            if (noteNode.getNodeType() == 1) {
                Map e2t = AutomatonTransducer.elementsToText(noteNode);
                Point p = new Point();
                boolean hasLocation = true;
                Object obj = e2t.get(NOTE_TEXT_NAME);
                if (obj != null) {
                    String textString = obj.toString();
                    double x = 0.0;
                    double y = 0.0;
                    try {
                        x = Double.parseDouble(e2t.get(STATE_X_COORD_NAME).toString());
                    }
                    catch (NullPointerException e) {
                        hasLocation = false;
                    }
                    catch (NumberFormatException e) {
                        throw new DataException("The x coordinate " + e2t.get(STATE_X_COORD_NAME) + " could not be read for the note with text " + textString + ".");
                    }
                    try {
                        y = Double.parseDouble(e2t.get(STATE_Y_COORD_NAME).toString());
                    }
                    catch (NullPointerException e) {
                        hasLocation = false;
                    }
                    catch (NumberFormatException e) {
                        throw new DataException("The y coordinate " + e2t.get(STATE_Y_COORD_NAME) + " could not be read for the note with text " + textString + ".");
                    }
                    p.setLocation(x, y);
                    root.addNote(new Note(p, textString));
                }
            }
            ++i;
        }
    }

    private void readBlocks(Node parent, Automaton root, Set states, Document document) {
        HashMap i2b = new HashMap();
        this.addBlocks(parent, root, states, i2b, document);
    }

    protected Element createStateElement(Document document, State state, Automaton container) {
        Element se = AutomatonTransducer.createElement(document, STATE_NAME, null, null);
        se.setAttribute(STATE_ID_NAME, "" + state.getID());
        se.appendChild(AutomatonTransducer.createElement(document, STATE_X_COORD_NAME, null, "" + state.getPoint().getX()));
        se.appendChild(AutomatonTransducer.createElement(document, STATE_Y_COORD_NAME, null, "" + state.getPoint().getY()));
        if (state.getLabel() != null) {
            se.appendChild(AutomatonTransducer.createElement(document, STATE_LABEL_NAME, null, state.getLabel()));
        }
        if (state.getName() != null) {
            se.setAttribute(STATE_NAME_NAME, state.getName());
        }
        State parent = state.getParentBlock();
        Automaton a = null;
        if (parent != null) {
            a = (Automaton)container.getBlockMap().get(parent.getInternalName());
        }
        if (a == null) {
            a = container;
        }
        if (a.getInitialState() == state) {
            se.appendChild(AutomatonTransducer.createElement(document, STATE_INITIAL_NAME, null, null));
        }
        if (a.isFinalState(state)) {
            se.appendChild(AutomatonTransducer.createElement(document, STATE_FINAL_NAME, null, null));
        }
        return se;
    }

    protected Element createTransitionElement(Document document, Transition transition) {
        Element te = AutomatonTransducer.createElement(document, TRANSITION_NAME, null, null);
        te.appendChild(AutomatonTransducer.createElement(document, TRANSITION_FROM_NAME, null, "" + transition.getFromState().getID()));
        te.appendChild(AutomatonTransducer.createElement(document, TRANSITION_TO_NAME, null, "" + transition.getToState().getID()));
        return te;
    }

    protected Element createBlockElement(Document document, State block, Automaton container) {
        Element be = AutomatonTransducer.createElement(document, "block", null, null);
        be.setAttribute(STATE_ID_NAME, "" + block.getID());
        if (block.getName() != null) {
            be.setAttribute(STATE_NAME_NAME, block.getName());
        }
        be.appendChild(AutomatonTransducer.createElement(document, FILE_NAME, null, block.getInternalName()));
        be.appendChild(AutomatonTransducer.createElement(document, STATE_X_COORD_NAME, null, "" + block.getPoint().getX()));
        be.appendChild(AutomatonTransducer.createElement(document, STATE_Y_COORD_NAME, null, "" + block.getPoint().getY()));
        State parent = block.getParentBlock();
        Automaton a = null;
        if (parent != null) {
            a = (Automaton)container.getBlockMap().get(parent.getInternalName());
        }
        if (a == null) {
            a = container;
        }
        if (a.getInitialState() == block) {
            be.appendChild(AutomatonTransducer.createElement(document, STATE_INITIAL_NAME, null, null));
        }
        if (a.isFinalState(block)) {
            be.appendChild(AutomatonTransducer.createElement(document, STATE_FINAL_NAME, null, null));
        }
        return be;
    }

    protected Element createAutomatonElement(Document document, Automaton auto, String name) {
        Element se = document.getDocumentElement();
        Element be = AutomatonTransducer.createElement(document, name, null, null);
        se.appendChild(be);
        this.writeFields(document, auto, be);
        return be;
    }

    public Document toDOM(Serializable structure) {
        Automaton automaton;
        this.originalAutomaton = automaton = (Automaton)structure;
        Document doc = this.newEmptyDocument();
        Element se = doc.getDocumentElement();
        se.appendChild(this.createAutomatonElement(doc, automaton, AUTOMATON_NAME));
        return doc;
    }

    private Element writeFields(Document doc, Automaton auto, Element se) {
        State[] states = auto.getStates();
        if (states.length > 0) {
            se.appendChild(AutomatonTransducer.createComment(doc, COMMENT_STATES));
        }
        int i = 0;
        while (i < states.length) {
            if (states[i].getInternalName() == null) {
                se.appendChild(this.createStateElement(doc, states[i], auto));
            } else {
                se.appendChild(this.createBlockElement(doc, states[i], auto));
            }
            ++i;
        }
        Transition[] transitions = auto.getTransitions();
        if (transitions.length > 0) {
            se.appendChild(AutomatonTransducer.createComment(doc, COMMENT_TRANSITIONS));
        }
        int i2 = 0;
        while (i2 < transitions.length) {
            se.appendChild(this.createTransitionElement(doc, transitions[i2]));
            ++i2;
        }
        Map references = auto.getBlockMap();
        Iterator refer = references.keySet().iterator();
        if (refer.hasNext()) {
            se.appendChild(AutomatonTransducer.createComment(doc, COMMENT_AUTOMATA));
        }
        while (refer.hasNext()) {
            String name = (String)refer.next();
            if (this.automatonMap.containsKey((Automaton)references.get(name))) continue;
            se.appendChild(this.createAutomatonElement(doc, (Automaton)references.get(name), name));
            this.automatonMap.put(name, auto);
        }
        ArrayList notes = auto.getNotes();
        int k = 0;
        while (k < notes.size()) {
            se.appendChild(this.createNoteElement(doc, (Note)notes.get(k)));
            ++k;
        }
        return se;
    }

    private Node createNoteElement(Document doc, Note note) {
        Element ne = AutomatonTransducer.createElement(doc, NOTE_NAME, null, null);
        ne.appendChild(AutomatonTransducer.createElement(doc, NOTE_TEXT_NAME, null, note.getText()));
        ne.appendChild(AutomatonTransducer.createElement(doc, STATE_X_COORD_NAME, null, "" + note.getLocation().getX()));
        ne.appendChild(AutomatonTransducer.createElement(doc, STATE_Y_COORD_NAME, null, "" + note.getLocation().getY()));
        return ne;
    }
}

