/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.xml.PumpingLemmaFactory;
import file.xml.PumpingLemmaTransducer;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pumping.Case;
import pumping.ContextFreePumpingLemma;

public class CFPumpingLemmaTransducer
extends PumpingLemmaTransducer {
    public static String TYPE = "context-free pumping lemma";
    public static String U_NAME = "uLength";
    public static String V_NAME = "vLength";
    public static String X_NAME = "xLength";
    public static String Y_NAME = "yLength";
    public static String CASE_NAME = "case";
    public static String CASE_I_NAME = "caseI";
    public static String CASE_U_NAME = "caseULength";
    public static String CASE_V_NAME = "caseVLength";
    public static String CASE_X_NAME = "caseXLength";
    public static String CASE_Y_NAME = "caseYLength";

    public Serializable fromDOM(Document document) {
        ContextFreePumpingLemma pl = (ContextFreePumpingLemma)PumpingLemmaFactory.createPumpingLemma(TYPE, document.getElementsByTagName(LEMMA_NAME).item(0).getTextContent());
        pl.chooseM(Integer.parseInt(document.getElementsByTagName(M_NAME).item(0).getTextContent()));
        this.readCases(document, pl);
        int uLength = Integer.parseInt(document.getElementsByTagName(U_NAME).item(0).getTextContent());
        int vLength = Integer.parseInt(document.getElementsByTagName(V_NAME).item(0).getTextContent());
        int xLength = Integer.parseInt(document.getElementsByTagName(X_NAME).item(0).getTextContent());
        int yLength = Integer.parseInt(document.getElementsByTagName(Y_NAME).item(0).getTextContent());
        pl.chooseDecomposition(new int[]{uLength, vLength, xLength, yLength});
        pl.setI(Integer.parseInt(document.getElementsByTagName(I_NAME).item(0).getTextContent()));
        return pl;
    }

    protected void readCases(Document doc, ContextFreePumpingLemma pl) {
        NodeList caseNodes = doc.getDocumentElement().getElementsByTagName(CASE_NAME);
        int i = 0;
        while (i < caseNodes.getLength()) {
            Node caseNode = caseNodes.item(i);
            if (caseNode.getNodeType() == 1) {
                int u = Integer.parseInt(((Element)caseNode).getElementsByTagName(CASE_U_NAME).item(0).getTextContent());
                int v = Integer.parseInt(((Element)caseNode).getElementsByTagName(CASE_V_NAME).item(0).getTextContent());
                int x = Integer.parseInt(((Element)caseNode).getElementsByTagName(CASE_X_NAME).item(0).getTextContent());
                int y = Integer.parseInt(((Element)caseNode).getElementsByTagName(CASE_Y_NAME).item(0).getTextContent());
                int j = Integer.parseInt(((Element)caseNode).getElementsByTagName(CASE_I_NAME).item(0).getTextContent());
                pl.addCase(new int[]{u, v, x, y}, j);
            }
            ++i;
        }
    }

    public Document toDOM(Serializable structure) {
        ContextFreePumpingLemma pl = (ContextFreePumpingLemma)structure;
        Document doc = this.newEmptyDocument();
        Element elem = doc.getDocumentElement();
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, LEMMA_NAME, null, pl.getTitle()));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, M_NAME, null, "" + pl.getM()));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, I_NAME, null, "" + pl.getI()));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, U_NAME, null, "" + pl.getU().length()));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, V_NAME, null, "" + pl.getV().length()));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, X_NAME, null, "" + pl.getX().length()));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, Y_NAME, null, "" + pl.getY().length()));
        ArrayList cases = pl.getDoneCases();
        if (cases != null && cases.size() > 0) {
            int i = 0;
            while (i < cases.size()) {
                elem.appendChild(this.createCaseElement(doc, (Case)cases.get(i)));
                ++i;
            }
        }
        return doc;
    }

    protected Element createCaseElement(Document doc, Case c) {
        Element elem = CFPumpingLemmaTransducer.createElement(doc, CASE_NAME, null, null);
        int[] decomposition = c.getInput();
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, CASE_U_NAME, null, "" + decomposition[0]));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, CASE_V_NAME, null, "" + decomposition[1]));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, CASE_X_NAME, null, "" + decomposition[2]));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, CASE_Y_NAME, null, "" + decomposition[3]));
        elem.appendChild(CFPumpingLemmaTransducer.createElement(doc, CASE_I_NAME, null, "" + c.getI()));
        return elem;
    }

    public String getType() {
        return TYPE;
    }
}

