/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.xml.AbstractTransducer;
import grammar.Grammar;
import grammar.Production;
import grammar.UnboundGrammar;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GrammarTransducer
extends AbstractTransducer {
    public static final String PRODUCTION_NAME = "production";
    public static final String PRODUCTION_LEFT_NAME = "left";
    public static final String PRODUCTION_RIGHT_NAME = "right";
    private static final String COMMENT_PRODUCTIONS = "The list of productions.";

    public String getType() {
        return "grammar";
    }

    public static Production createProduction(Node node) {
        Map e2t = GrammarTransducer.elementsToText(node);
        String left = (String)e2t.get(PRODUCTION_LEFT_NAME);
        String right = (String)e2t.get(PRODUCTION_RIGHT_NAME);
        if (left == null) {
            left = "";
        }
        if (right == null) {
            right = "";
        }
        return new Production(left, right);
    }

    public static Element createProductionElement(Document document, Production production) {
        Element pe = GrammarTransducer.createElement(document, PRODUCTION_NAME, null, null);
        pe.appendChild(GrammarTransducer.createElement(document, PRODUCTION_LEFT_NAME, null, production.getLHS()));
        pe.appendChild(GrammarTransducer.createElement(document, PRODUCTION_RIGHT_NAME, null, production.getRHS()));
        return pe;
    }

    public Serializable fromDOM(Document document) {
        UnboundGrammar g = new UnboundGrammar();
        NodeList list = document.getDocumentElement().getElementsByTagName(PRODUCTION_NAME);
        int i = 0;
        while (i < list.getLength()) {
            Production p = GrammarTransducer.createProduction(list.item(i));
            g.addProduction(p);
            ++i;
        }
        return g;
    }

    public Document toDOM(Serializable structure) {
        Grammar grammar = (Grammar)structure;
        Document doc = this.newEmptyDocument();
        Element se = doc.getDocumentElement();
        Production[] productions = grammar.getProductions();
        if (productions.length > 0) {
            se.appendChild(GrammarTransducer.createComment(doc, COMMENT_PRODUCTIONS));
        }
        int i = 0;
        while (i < productions.length) {
            se.appendChild(GrammarTransducer.createProductionElement(doc, productions[i]));
            ++i;
        }
        return doc;
    }
}

