/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.ParseException;
import file.xml.AbstractTransducer;
import grammar.Grammar;
import grammar.Production;
import grammar.UnboundGrammar;
import grammar.lsystem.LSystem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LSystemTransducer
extends AbstractTransducer {
    public static final String AXIOM_NAME = "axiom";
    public static final String RULE_NAME = "production";
    public static final String RULE_LEFT_NAME = "left";
    public static final String RULE_RIGHT_NAME = "right";
    public static final String PARAMETER_NAME = "parameter";
    public static final String PARAMETER_NAME_NAME = "name";
    public static final String PARAMETER_VALUE_NAME = "value";
    private static final String COMMENT_AXIOM = "The L-system axiom.";
    private static final String COMMENT_RULE = "The rewriting rules.";
    private static final String COMMENT_PARAMETER = "The drawing parameters.";

    public String getType() {
        return "lsystem";
    }

    private static String listAsString(List list) {
        Iterator it = list.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(' ');
            sb.append(it.next());
        }
        return sb.toString();
    }

    private static Production[] createRules(Node node) {
        Map e2t = LSystemTransducer.elementsToText(node);
        String left = (String)e2t.get(RULE_LEFT_NAME);
        if (left == null) {
            left = "";
        }
        NodeList list = ((Element)node).getElementsByTagName(RULE_RIGHT_NAME);
        Production[] p = new Production[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            String right = LSystemTransducer.containedText(list.item(i));
            p[i] = new Production(left, right == null ? "" : right);
            ++i;
        }
        return p;
    }

    public static Element createRuleElement(Document document, LSystem lsystem, String left) {
        Element re = LSystemTransducer.createElement(document, RULE_NAME, null, null);
        re.appendChild(LSystemTransducer.createElement(document, RULE_LEFT_NAME, null, left));
        List[] replacements = lsystem.getReplacements(left);
        int i = 0;
        while (i < replacements.length) {
            re.appendChild(LSystemTransducer.createElement(document, RULE_RIGHT_NAME, null, LSystemTransducer.listAsString(replacements[i])));
            ++i;
        }
        return re;
    }

    private String readAxiom(Document document) {
        NodeList list = document.getDocumentElement().getElementsByTagName(AXIOM_NAME);
        if (list.getLength() < 1) {
            throw new ParseException("No axiom specified in the document!");
        }
        String axiom = LSystemTransducer.containedText(list.item(list.getLength() - 1));
        if (axiom == null) {
            axiom = "";
        }
        return axiom;
    }

    private Grammar readGrammar(Document document) {
        UnboundGrammar g = new UnboundGrammar();
        NodeList list = document.getDocumentElement().getElementsByTagName(RULE_NAME);
        int i = 0;
        while (i < list.getLength()) {
            Production[] p = LSystemTransducer.createRules(list.item(i));
            int j = 0;
            while (j < p.length) {
                g.addProduction(p[j]);
                ++j;
            }
            ++i;
        }
        return g;
    }

    private Map readParameters(Document document) {
        HashMap<String, String> p = new HashMap<String, String>();
        NodeList list = document.getDocumentElement().getElementsByTagName(PARAMETER_NAME);
        int i = 0;
        while (i < list.getLength()) {
            Map e2t = LSystemTransducer.elementsToText(list.item(i));
            String name = (String)e2t.get(PARAMETER_NAME_NAME);
            String value = (String)e2t.get(PARAMETER_VALUE_NAME);
            if (name != null) {
                if (value == null) {
                    value = "";
                }
                p.put(name, value);
            }
            ++i;
        }
        return p;
    }

    public Serializable fromDOM(Document document) {
        String axiom = this.readAxiom(document);
        Grammar rules = this.readGrammar(document);
        Map parameters = this.readParameters(document);
        return new LSystem(axiom, rules, parameters);
    }

    public Document toDOM(Serializable structure) {
        LSystem lsystem = (LSystem)structure;
        Document doc = this.newEmptyDocument();
        Element se = doc.getDocumentElement();
        se.appendChild(LSystemTransducer.createComment(doc, COMMENT_AXIOM));
        se.appendChild(LSystemTransducer.createElement(doc, AXIOM_NAME, null, LSystemTransducer.listAsString(lsystem.getAxiom())));
        Set symbols = lsystem.getSymbolsWithReplacements();
        Iterator<Object> it = symbols.iterator();
        if (it.hasNext()) {
            se.appendChild(LSystemTransducer.createComment(doc, COMMENT_RULE));
        }
        while (it.hasNext()) {
            se.appendChild(LSystemTransducer.createRuleElement(doc, lsystem, (String)it.next()));
        }
        Map parameters = lsystem.getValues();
        it = parameters.keySet().iterator();
        if (it.hasNext()) {
            se.appendChild(LSystemTransducer.createComment(doc, COMMENT_PARAMETER));
        }
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = (String)parameters.get(name);
            Element pe = LSystemTransducer.createElement(doc, PARAMETER_NAME, null, null);
            pe.appendChild(LSystemTransducer.createElement(doc, PARAMETER_NAME_NAME, null, name));
            pe.appendChild(LSystemTransducer.createElement(doc, PARAMETER_VALUE_NAME, null, value));
            se.appendChild(pe);
        }
        return doc;
    }
}

