/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.xml.PumpingLemmaFactory;
import file.xml.PumpingLemmaTransducer;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pumping.RegularPumpingLemma;

public class RegPumpingLemmaTransducer
extends PumpingLemmaTransducer {
    public static String TYPE = "regular pumping lemma";
    public static String X_NAME = "xLength";
    public static String Y_NAME = "yLength";

    public Serializable fromDOM(Document document) {
        RegularPumpingLemma pl = (RegularPumpingLemma)PumpingLemmaFactory.createPumpingLemma(TYPE, document.getElementsByTagName(LEMMA_NAME).item(0).getTextContent());
        pl.chooseM(Integer.parseInt(document.getElementsByTagName(M_NAME).item(0).getTextContent()));
        int xLength = Integer.parseInt(document.getElementsByTagName(X_NAME).item(0).getTextContent());
        int yLength = Integer.parseInt(document.getElementsByTagName(Y_NAME).item(0).getTextContent());
        pl.chooseDecomposition(new int[]{xLength, yLength});
        pl.setI(Integer.parseInt(document.getElementsByTagName(I_NAME).item(0).getTextContent()));
        return pl;
    }

    public Document toDOM(Serializable structure) {
        RegularPumpingLemma pl = (RegularPumpingLemma)structure;
        Document doc = this.newEmptyDocument();
        Element elem = doc.getDocumentElement();
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, LEMMA_NAME, null, pl.getTitle()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, M_NAME, null, "" + pl.getM()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, I_NAME, null, "" + pl.getI()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, X_NAME, null, "" + pl.getX().length()));
        elem.appendChild(RegPumpingLemmaTransducer.createElement(doc, Y_NAME, null, "" + pl.getY().length()));
        return doc;
    }

    public String getType() {
        return TYPE;
    }
}

