/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.GrammarChecker;
import grammar.Production;
import gui.environment.EnvironmentFrame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Grammar
implements Serializable,
Cloneable {
    private EnvironmentFrame myEnvFrame = null;
    private String fileName = "";
    protected Set myVariables;
    protected Set myTerminals;
    protected String myStartVariable = null;
    protected List myProductions = new ArrayList();

    public Grammar() {
        this.myVariables = new HashSet();
        this.myTerminals = new HashSet();
    }

    public Object clone() {
        Grammar g;
        try {
            g = (Grammar)this.getClass().newInstance();
        }
        catch (Throwable e) {
            System.err.println("Warning: clone of grammar failed!");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] variables = this.getVariables();
        int v = 0;
        while (v < variables.length) {
            String variable = variables[v];
            String nvariable = new String(variables[v]);
            map.put(variable, nvariable);
            g.addVariable(nvariable);
            ++v;
        }
        g.setStartVariable((String)map.get(this.getStartVariable()));
        String[] terminals = this.getTerminals();
        int t = 0;
        while (t < terminals.length) {
            g.addTerminal(new String(terminals[t]));
            ++t;
        }
        Production[] productions = this.getProductions();
        int p = 0;
        while (p < productions.length) {
            String rhs = productions[p].getRHS();
            String lhs = productions[p].getLHS();
            g.addProduction(new Production(rhs, lhs));
            ++p;
        }
        return g;
    }

    public void setStartVariable(String variable) {
        this.myStartVariable = variable;
    }

    public String getStartVariable() {
        return this.myStartVariable;
    }

    public boolean isValidProduction(Production production) {
        try {
            this.checkProduction(production);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public abstract void checkProduction(Production var1);

    public void addProduction(Production production) {
        this.checkProduction(production);
        GrammarChecker gc = new GrammarChecker();
        if (GrammarChecker.isProductionInGrammar(production, this)) {
            return;
        }
        this.myProductions.add(production);
        String[] variablesInProduction = production.getVariables();
        int k = 0;
        while (k < variablesInProduction.length) {
            if (!this.myVariables.contains(variablesInProduction[k])) {
                this.addVariable(variablesInProduction[k]);
            }
            ++k;
        }
        String[] terminalsInProduction = production.getTerminals();
        int i = 0;
        while (i < terminalsInProduction.length) {
            if (!this.myTerminals.contains(terminalsInProduction[i])) {
                this.addTerminal(terminalsInProduction[i]);
            }
            ++i;
        }
    }

    public void addProductions(Production[] productions) {
        int k = 0;
        while (k < productions.length) {
            this.addProduction(productions[k]);
            ++k;
        }
    }

    public void removeProduction(Production production) {
        this.myProductions.remove(production);
        GrammarChecker gc = new GrammarChecker();
        String[] variablesInProduction = production.getVariables();
        int k = 0;
        while (k < variablesInProduction.length) {
            if (!GrammarChecker.isVariableInProductions(this, variablesInProduction[k])) {
                this.removeVariable(variablesInProduction[k]);
            }
            ++k;
        }
        String[] terminalsInProduction = production.getTerminals();
        int i = 0;
        while (i < terminalsInProduction.length) {
            if (!GrammarChecker.isTerminalInProductions(this, terminalsInProduction[i])) {
                this.removeTerminal(terminalsInProduction[i]);
            }
            ++i;
        }
    }

    public Production[] getProductions() {
        return this.myProductions.toArray(new Production[0]);
    }

    private void addTerminal(String terminal) {
        this.myTerminals.add(terminal);
    }

    private void removeTerminal(String terminal) {
        this.myTerminals.remove(terminal);
    }

    public String[] getTerminals() {
        return this.myTerminals.toArray(new String[0]);
    }

    private void addVariable(String variable) {
        this.myVariables.add(variable);
    }

    private void removeVariable(String variable) {
        this.myVariables.remove(variable);
    }

    public String[] getVariables() {
        return this.myVariables.toArray(new String[0]);
    }

    public boolean isProduction(Production production) {
        return this.myProductions.contains(production);
    }

    public boolean isTerminal(String terminal) {
        return this.myTerminals.contains(terminal);
    }

    public boolean isVariable(String variable) {
        return this.myVariables.contains(variable);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append('\n');
        buffer.append("V: ");
        String[] variables = this.getVariables();
        int v = 0;
        while (v < variables.length) {
            buffer.append(variables[v]);
            buffer.append(" ");
            ++v;
        }
        buffer.append('\n');
        buffer.append("T: ");
        String[] terminals = this.getTerminals();
        int t = 0;
        while (t < terminals.length) {
            buffer.append(terminals[t]);
            buffer.append(" ");
            ++t;
        }
        buffer.append('\n');
        buffer.append("S: ");
        buffer.append(this.getStartVariable());
        buffer.append('\n');
        buffer.append("P: ");
        buffer.append('\n');
        Production[] productions = this.getProductions();
        int p = 0;
        while (p < productions.length) {
            buffer.append(productions[p].toString());
            buffer.append('\n');
            ++p;
        }
        return buffer.toString();
    }

    public void setEnvironmentFrame(EnvironmentFrame frame) {
        this.myEnvFrame = frame;
    }

    public EnvironmentFrame getEnvironmentFrame() {
        return this.myEnvFrame;
    }

    public void setFilePath(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        int last = this.fileName.lastIndexOf("\\");
        if (last == -1) {
            last = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(last + 1);
    }

    public String getFilePath() {
        int last = this.fileName.lastIndexOf("\\");
        if (last == -1) {
            last = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(0, last + 1);
    }
}

