/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.Production;
import grammar.ProductionChecker;
import java.util.ArrayList;
import java.util.HashSet;

public class GrammarChecker {
    public static boolean isRegularGrammar(Grammar grammar) {
        return GrammarChecker.isRightLinearGrammar(grammar) || GrammarChecker.isLeftLinearGrammar(grammar);
    }

    public static boolean isRightLinearGrammar(Grammar grammar) {
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (!ProductionChecker.isRightLinear(productions[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public static boolean isLeftLinearGrammar(Grammar grammar) {
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (!ProductionChecker.isLeftLinear(productions[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public static boolean isContextFreeGrammar(Grammar grammar) {
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (!ProductionChecker.isRestrictedOnLHS(productions[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public static boolean isVariableInProductions(Grammar grammar, String variable) {
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (ProductionChecker.isVariableInProduction(variable, productions[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static boolean isTerminalInProductions(Grammar grammar, String terminal) {
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (ProductionChecker.isTerminalInProduction(terminal, productions[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static Production[] getProductionsOnVariable(String variable, Grammar grammar) {
        ArrayList<Production> list = new ArrayList<Production>();
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (variable.equals(productions[k].getLHS())) {
                list.add(productions[k]);
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public static Production[] getNonUnitProductionsOnVariable(String variable, Grammar grammar) {
        ArrayList<Production> list = new ArrayList<Production>();
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (variable.equals(productions[k].getLHS()) && !ProductionChecker.isUnitProduction(productions[k])) {
                list.add(productions[k]);
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public static boolean isProductionInGrammar(Production production, Grammar grammar) {
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (production.equals(productions[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static Production[] getProductionsWithVariable(String variable, Grammar grammar) {
        ArrayList<Production> list = new ArrayList<Production>();
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (ProductionChecker.isVariableInProduction(variable, productions[k])) {
                list.add(productions[k]);
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public static Production[] getProductionsWithVariableOnRHS(String variable, Grammar grammar) {
        ProductionChecker pc = new ProductionChecker();
        ArrayList<Production> list = new ArrayList<Production>();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (ProductionChecker.isVariableOnRHS(productions[k], variable)) {
                list.add(productions[k]);
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public static String[] getUnresolvedVariables(Grammar grammar) {
        String[] variables = grammar.getVariables();
        HashSet<String> variableSet = new HashSet<String>();
        int i = 0;
        while (i < variables.length) {
            variableSet.add(variables[i]);
            ++i;
        }
        Production[] productions = grammar.getProductions();
        int i2 = 0;
        while (i2 < productions.length) {
            String[] lhsVariables = productions[i2].getVariablesOnLHS();
            int j = 0;
            while (j < lhsVariables.length) {
                variableSet.remove(lhsVariables[j]);
                ++j;
            }
            ++i2;
        }
        return variableSet.toArray(new String[0]);
    }
}

