/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.ProductionChecker;
import gui.environment.Universe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public class Production
implements Serializable {
    protected String myLHS;
    protected String myRHS;

    public Production(String lhs, String rhs) {
        if (lhs == null) {
            lhs = "";
        }
        if (rhs == null) {
            rhs = "";
        }
        this.myLHS = lhs;
        this.myRHS = rhs;
    }

    public void setRHS(String rhs) {
        this.myRHS = rhs;
    }

    public void setLHS(String lhs) {
        this.myLHS = lhs;
    }

    public String getLHS() {
        return this.myLHS;
    }

    public String getRHS() {
        return this.myRHS;
    }

    public String[] getSymbols() {
        TreeSet<String> symbols = new TreeSet<String>();
        symbols.addAll(Arrays.asList(this.getVariables()));
        symbols.addAll(Arrays.asList(this.getTerminals()));
        return symbols.toArray(new String[0]);
    }

    public String[] getVariables() {
        ArrayList<String> list = new ArrayList<String>();
        String[] rhsVariables = this.getVariablesOnRHS();
        int k = 0;
        while (k < rhsVariables.length) {
            if (!list.contains(rhsVariables[k])) {
                list.add(rhsVariables[k]);
            }
            ++k;
        }
        String[] lhsVariables = this.getVariablesOnLHS();
        int i = 0;
        while (i < lhsVariables.length) {
            if (!list.contains(lhsVariables[i])) {
                list.add(lhsVariables[i]);
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public String[] getVariablesOnLHS() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.myLHS == null) {
            return new String[0];
        }
        int i = 0;
        while (i < this.myLHS.length()) {
            char c = this.myLHS.charAt(i);
            if (ProductionChecker.isVariable(c)) {
                list.add(this.myLHS.substring(i, i + 1));
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public String[] getVariablesOnRHS() {
        ProductionChecker pc = new ProductionChecker();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.myRHS.length()) {
            char c = this.myRHS.charAt(i);
            if (ProductionChecker.isVariable(c)) {
                list.add(this.myRHS.substring(i, i + 1));
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public String[] getTerminals() {
        ArrayList<String> list = new ArrayList<String>();
        String[] rhsTerminals = this.getTerminalsOnRHS();
        int k = 0;
        while (k < rhsTerminals.length) {
            if (!list.contains(rhsTerminals[k])) {
                list.add(rhsTerminals[k]);
            }
            ++k;
        }
        String[] lhsTerminals = this.getTerminalsOnLHS();
        int i = 0;
        while (i < lhsTerminals.length) {
            if (!list.contains(lhsTerminals[i])) {
                list.add(lhsTerminals[i]);
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public String[] getTerminalsOnRHS() {
        ProductionChecker pc = new ProductionChecker();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.myRHS.length()) {
            char c = this.myRHS.charAt(i);
            if (ProductionChecker.isTerminal(c)) {
                list.add(this.myRHS.substring(i, i + 1));
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public boolean equals(Object production) {
        if (production instanceof Production) {
            Production p = (Production)production;
            return this.getRHS().equals(p.getRHS()) && this.getLHS().equals(p.getLHS());
        }
        return false;
    }

    public int hashCode() {
        return this.myRHS.hashCode() ^ this.myLHS.hashCode();
    }

    public String[] getTerminalsOnLHS() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.myLHS.length()) {
            char c = this.myLHS.charAt(i);
            if (ProductionChecker.isTerminal(c)) {
                list.add(this.myLHS.substring(i, i + 1));
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLHS());
        buffer.append('\u2192');
        String rhs = this.getRHS();
        buffer.append(rhs.length() == 0 ? Universe.curProfile.getEmptyString() : rhs);
        return buffer.toString();
    }

    public String[] getSymbolsOnRHS() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.myRHS.length()) {
            char c = this.myRHS.charAt(i);
            list.add(this.myRHS.substring(i, i + 1));
            ++i;
        }
        return list.toArray(new String[0]);
    }
}

