/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import automata.State;
import automata.Transition;
import automata.UnreachableStatesDetector;
import automata.vdg.VDGTransition;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.GrammarChecker;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.cfg.ContextFreeGrammar;
import java.awt.Point;
import java.util.ArrayList;

public class UnitProductionRemover {
    public VariableDependencyGraph getVariableDependencyGraph(Grammar grammar) {
        VariableDependencyGraph graph = new VariableDependencyGraph();
        this.initializeDependencyGraph(graph, grammar);
        Production[] uprods = this.getUnitProductions(grammar);
        int k = 0;
        while (k < uprods.length) {
            graph.addTransition(this.getTransitionForUnitProduction(uprods[k], graph));
            ++k;
        }
        return graph;
    }

    public Production[] getUnitProductions(Grammar grammar) {
        ArrayList<Production> list = new ArrayList<Production>();
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (ProductionChecker.isUnitProduction(productions[k])) {
                list.add(productions[k]);
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public Production[] getNonUnitProductions(Grammar grammar) {
        ArrayList<Production> list = new ArrayList<Production>();
        ProductionChecker pc = new ProductionChecker();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (!ProductionChecker.isUnitProduction(productions[k])) {
                list.add(productions[k]);
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public void initializeDependencyGraph(VariableDependencyGraph graph, Grammar grammar) {
        String[] variables = grammar.getVariables();
        int k = 0;
        while (k < variables.length) {
            double theta = Math.PI * 2 * (double)k / (double)variables.length;
            Point point = new Point(200 + (int)(180.0 * Math.cos(theta)), 200 + (int)(180.0 * Math.sin(theta)));
            State state = graph.createState(point);
            state.setName(variables[k]);
            ++k;
        }
    }

    public State getStateForVariable(String variable, VariableDependencyGraph graph) {
        State[] states = graph.getStates();
        int k = 0;
        while (k < states.length) {
            if (states[k].getName().equals(variable)) {
                return states[k];
            }
            ++k;
        }
        return null;
    }

    public Transition getTransitionForUnitProduction(Production production, VariableDependencyGraph graph) {
        ProductionChecker pc = new ProductionChecker();
        if (!ProductionChecker.isUnitProduction(production)) {
            return null;
        }
        String lhs = production.getLHS();
        String rhs = production.getRHS();
        State from = this.getStateForVariable(lhs, graph);
        State to = this.getStateForVariable(rhs, graph);
        return new VDGTransition(from, to);
    }

    public void addAllNonUnitProductionsToGrammar(Grammar oldGrammar, Grammar newGrammar) {
        Production[] productions = this.getNonUnitProductions(oldGrammar);
        int k = 0;
        while (k < productions.length) {
            newGrammar.addProduction(productions[k]);
            ++k;
        }
    }

    public boolean isDependentOn(String variable1, String variable2, VariableDependencyGraph graph) {
        State v1 = this.getStateForVariable(variable1, graph);
        State v2 = this.getStateForVariable(variable2, graph);
        graph.setInitialState(v1);
        UnreachableStatesDetector usd = new UnreachableStatesDetector(graph);
        State[] states = usd.getUnreachableStates();
        graph.setInitialState(null);
        int k = 0;
        while (k < states.length) {
            if (v2 == states[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public String[] getDependencies(String variable, Grammar grammar, VariableDependencyGraph graph) {
        ArrayList<String> list = new ArrayList<String>();
        String[] variables = grammar.getVariables();
        int k = 0;
        while (k < variables.length) {
            if (!variable.equals(variables[k]) && this.isDependentOn(variable, variables[k], graph)) {
                list.add(variables[k]);
            }
            ++k;
        }
        return list.toArray(new String[0]);
    }

    public Production[] getNewProductions(String variable, Production[] oldProductions) {
        ArrayList<Production> list = new ArrayList<Production>();
        int k = 0;
        while (k < oldProductions.length) {
            list.add(new Production(variable, oldProductions[k].getRHS()));
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public void addAllNewProductionsToGrammar(Grammar oldGrammar, Grammar newGrammar, VariableDependencyGraph graph) {
        GrammarChecker gc = new GrammarChecker();
        String[] variables = oldGrammar.getVariables();
        int k = 0;
        while (k < variables.length) {
            String v1 = variables[k];
            String[] dep = this.getDependencies(v1, oldGrammar, graph);
            int i = 0;
            while (i < dep.length) {
                Production[] prods = GrammarChecker.getNonUnitProductionsOnVariable(dep[i], oldGrammar);
                newGrammar.addProductions(this.getNewProductions(v1, prods));
                ++i;
            }
            ++k;
        }
    }

    public Grammar getUnitProductionlessGrammar(Grammar grammar, VariableDependencyGraph graph) {
        ContextFreeGrammar uplgrammar = new ContextFreeGrammar();
        this.addAllNonUnitProductionsToGrammar(grammar, uplgrammar);
        this.addAllNewProductionsToGrammar(grammar, uplgrammar, graph);
        return uplgrammar;
    }
}

