/*
 * Decompiled with CFR 0.152.
 */
package grammar.cfg;

import automata.Automaton;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.pda.PDATransition;
import grammar.Grammar;
import grammar.GrammarToAutomatonConverter;
import grammar.Production;

public class CFGToPDALRConverter
extends GrammarToAutomatonConverter {
    protected State START_STATE;

    private String getReverse(String string) {
        StringBuffer buffer = new StringBuffer();
        int k = string.length() - 1;
        while (k >= 0) {
            buffer.append(string.charAt(k));
            --k;
        }
        return buffer.toString();
    }

    public Transition getTransitionForProduction(Production production) {
        String lhs = production.getLHS();
        String rhs = production.getRHS();
        String rrhs = this.getReverse(rhs);
        PDATransition transition = new PDATransition(this.START_STATE, this.START_STATE, "", rrhs, lhs);
        return transition;
    }

    public void createStatesForConversion(Grammar grammar, Automaton automaton) {
        this.initialize();
        StatePlacer sp = new StatePlacer();
        State initialState = automaton.createState(sp.getPointForState(automaton));
        automaton.setInitialState(initialState);
        this.START_STATE = initialState;
        State intermediateState = automaton.createState(sp.getPointForState(automaton));
        State finalState = automaton.createState(sp.getPointForState(automaton));
        automaton.addFinalState(finalState);
        String startVariable = grammar.getStartVariable();
        PDATransition trans1 = new PDATransition(initialState, intermediateState, "", startVariable, "");
        automaton.addTransition(trans1);
        PDATransition trans2 = new PDATransition(intermediateState, finalState, "", this.BOTTOM_OF_STACK, "");
        automaton.addTransition(trans2);
        String[] terminals = grammar.getTerminals();
        int k = 0;
        while (k < terminals.length) {
            PDATransition trans = new PDATransition(initialState, initialState, terminals[k], "", terminals[k]);
            automaton.addTransition(trans);
            ++k;
        }
    }
}

