/*
 * Decompiled with CFR 0.152.
 */
package grammar.lsystem;

import grammar.lsystem.LSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Expander {
    private LSystem lsystem;
    private Random stochiastic;
    private List cachedExpansions = new ArrayList();
    private static final Random RANDOM = new Random();
    private Context[] contexts = null;
    protected static final List[] EMPTY_ARRAY = new List[0];

    public Expander(LSystem lsystem) {
        this(lsystem, RANDOM.nextLong());
    }

    public Expander(LSystem lsystem, long seed) {
        this.stochiastic = new Random(seed);
        this.lsystem = lsystem;
        this.cachedExpansions.add(lsystem.getAxiom());
        this.initializeContexts();
    }

    public List expansionForLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Recursion level " + level + " impossible!");
        }
        if (level < this.cachedExpansions.size()) {
            return (List)this.cachedExpansions.get(level);
        }
        List lastOne = (List)this.cachedExpansions.get(this.cachedExpansions.size() - 1);
        int i = this.cachedExpansions.size();
        while (i <= level) {
            lastOne = this.expand(lastOne);
            this.cachedExpansions.add(lastOne);
            ++i;
        }
        return lastOne;
    }

    private List expand(List symbols) {
        if (this.contexts == null) {
            return this.expandNoContext(symbols);
        }
        return this.expandContext(symbols);
    }

    private List expandNoContext(List symbols) {
        ArrayList<String> ne = new ArrayList<String>();
        int i = 0;
        while (i < symbols.size()) {
            block6: {
                String s = (String)symbols.get(i);
                List[] replacements = this.lsystem.getReplacements(s);
                List replacement = null;
                switch (replacements.length) {
                    case 0: {
                        ne.add(s);
                        break block6;
                    }
                    case 1: {
                        replacement = replacements[0];
                        break;
                    }
                    default: {
                        replacement = replacements[this.stochiastic.nextInt(replacements.length)];
                    }
                }
                Iterator it2 = replacement.iterator();
                while (it2.hasNext()) {
                    ne.add((String)it2.next());
                }
            }
            ++i;
        }
        return ne;
    }

    private List expandContext(List symbols) {
        ArrayList<String> ne = new ArrayList<String>();
        int i = 0;
        while (i < symbols.size()) {
            block8: {
                String s = (String)symbols.get(i);
                ArrayList<List> replacementsList = new ArrayList<List>();
                int j = 0;
                while (j < this.contexts.length) {
                    List[] l = this.contexts[j].matches(symbols, i);
                    int k = 0;
                    while (k < l.length) {
                        replacementsList.add(l[k]);
                        ++k;
                    }
                    ++j;
                }
                List[] replacements = replacementsList.toArray(EMPTY_ARRAY);
                List replacement = null;
                switch (replacements.length) {
                    case 0: {
                        ne.add(s);
                        break block8;
                    }
                    case 1: {
                        replacement = replacements[0];
                        break;
                    }
                    default: {
                        replacement = replacements[this.stochiastic.nextInt(replacements.length)];
                    }
                }
                Iterator it2 = replacement.iterator();
                while (it2.hasNext()) {
                    ne.add((String)it2.next());
                }
            }
            ++i;
        }
        return ne;
    }

    private final void initializeContexts() {
        Iterator symbolIt = this.lsystem.getSymbolsWithReplacements().iterator();
        HashSet searchLengths = new HashSet();
        Integer one = new Integer(1);
        ArrayList<Context> contextsList = new ArrayList<Context>();
        boolean hasContexts = false;
        block7: while (symbolIt.hasNext()) {
            String symbol = (String)symbolIt.next();
            List tokens = LSystem.tokenify(symbol);
            List[] replacements = this.lsystem.getReplacements(symbol);
            int context = 0;
            switch (tokens.size()) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    break;
                }
                default: {
                    try {
                        context = Integer.parseInt((String)tokens.get(0));
                        tokens.get(context + 1);
                    }
                    catch (NumberFormatException e) {
                        continue block7;
                    }
                    catch (IndexOutOfBoundsException e) {
                        continue block7;
                    }
                    hasContexts = true;
                    tokens = tokens.subList(1, tokens.size());
                }
            }
            contextsList.add(new Context(tokens, context, replacements));
        }
        if (hasContexts) {
            this.contexts = contextsList.toArray(new Context[0]);
        }
    }

    private class Context {
        protected List tokens;
        protected int center;
        protected List[] results;

        public Context(List tokens, int center, List[] results) {
            this.tokens = tokens;
            this.center = center;
            this.results = results;
        }

        public List[] matches(List list, int centerList) {
            centerList -= this.center;
            try {
                List sub = list.subList(centerList, centerList + this.tokens.size());
                if (sub.equals(this.tokens)) {
                    return this.results;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return EMPTY_ARRAY;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append(" : tokens(");
            sb.append(this.tokens);
            sb.append(") at ");
            sb.append(this.center);
            sb.append(" with ");
            sb.append(Arrays.asList(this.results));
            return sb.toString();
        }
    }
}

