/*
 * Decompiled with CFR 0.152.
 */
package grammar.lsystem;

import grammar.Grammar;
import grammar.Production;
import grammar.UnrestrictedGrammar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class LSystem
implements Serializable {
    private Map symbolToReplacements;
    private Map values;
    private List axiom;
    private boolean nondeterministic = false;
    private static final List[] EMPTY_LIST = new List[0];

    public LSystem() {
        this("", new UnrestrictedGrammar(), new HashMap());
    }

    public LSystem(String axiom, Grammar replacements, Map values) {
        this.values = Collections.unmodifiableMap(values);
        this.initReplacements(replacements);
        this.axiom = LSystem.tokenify(axiom);
    }

    public static List tokenify(String string) {
        StringTokenizer st = new StringTokenizer(string);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private void initReplacements(Grammar replacements) {
        HashMap reps = new HashMap();
        Production[] p = replacements.getProductions();
        int i = 0;
        while (i < p.length) {
            String replace = p[i].getLHS();
            ArrayList<List> currentReplacements = null;
            if (!reps.containsKey(replace)) {
                currentReplacements = new ArrayList<List>();
                reps.put(replace, currentReplacements);
            } else {
                currentReplacements = (ArrayList<List>)reps.get(replace);
            }
            List currentSubstitution = LSystem.tokenify(p[i].getRHS());
            try {
                List lastSubstitution = (List)currentReplacements.get(currentReplacements.size() - 1);
                if (!currentSubstitution.equals(lastSubstitution)) {
                    this.nondeterministic = true;
                }
            }
            catch (IndexOutOfBoundsException lastSubstitution) {
                // empty catch block
            }
            currentReplacements.add(currentSubstitution);
            ++i;
        }
        Iterator it = reps.entrySet().iterator();
        this.symbolToReplacements = new TreeMap();
        List[] emptyListArray = new List[]{};
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List l = (List)entry.getValue();
            List[] replacementArray = l.toArray(emptyListArray);
            this.symbolToReplacements.put(entry.getKey(), replacementArray);
        }
    }

    public List getAxiom() {
        return this.axiom;
    }

    public List[] getReplacements(String symbol) {
        List[] toReturn = (List[])this.symbolToReplacements.get(symbol);
        return toReturn == null ? EMPTY_LIST : toReturn;
    }

    public Set getSymbolsWithReplacements() {
        return this.symbolToReplacements.keySet();
    }

    public Map getValues() {
        return this.values;
    }

    public boolean nondeterministic() {
        return this.nondeterministic;
    }
}

