/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.Production;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class LRParseTable
extends AbstractTableModel
implements Serializable,
Cloneable {
    private String[] variables;
    private String[] terminals;
    private String[][] entries;
    private Grammar grammar;
    private Map symbolsToColumn = new HashMap();

    public LRParseTable(Grammar grammar, FiniteStateAutomaton fsa) {
        ArrayList<String> term = new ArrayList<String>(Arrays.asList(grammar.getTerminals()));
        ArrayList<String> vars = new ArrayList<String>(Arrays.asList(grammar.getVariables()));
        this.grammar = grammar;
        Collections.sort(term);
        Collections.sort(vars);
        term.add("$");
        this.terminals = term.toArray(new String[0]);
        this.variables = vars.toArray(new String[0]);
        int i = 0;
        while (i < this.terminals.length) {
            this.symbolsToColumn.put(this.terminals[i], new Integer(i + 1));
            ++i;
        }
        i = 0;
        while (i < this.variables.length) {
            this.symbolsToColumn.put(this.variables[i], new Integer(i + 1 + this.terminals.length));
            ++i;
        }
        this.entries = new String[fsa.getStates().length][this.terminals.length + this.variables.length + 1];
        i = 0;
        while (i < this.entries.length) {
            int j = 0;
            while (j < this.entries[i].length) {
                this.entries[i][j] = j == 0 ? Integer.toString(i) : "";
                ++j;
            }
            ++i;
        }
    }

    public LRParseTable(LRParseTable table) {
        this.terminals = table.terminals;
        this.variables = table.variables;
        this.grammar = table.grammar;
        this.entries = new String[table.entries.length][table.entries[0].length];
        int i = 0;
        while (i < this.entries.length) {
            int j = 0;
            while (j < this.entries[i].length) {
                this.entries[i][j] = table.entries[i][j];
                ++j;
            }
            ++i;
        }
        this.symbolsToColumn = table.symbolsToColumn;
    }

    public Object clone() {
        return new LRParseTable(this);
    }

    public void setValueAt(String value, int id, String symbol) {
        this.setValueAt((Object)value, id, this.columnForSymbol(symbol));
    }

    public String getValueAt(int id, String symbol) {
        return (String)this.getValueAt(id, this.columnForSymbol(symbol));
    }

    public SortedSet getSetAt(int id, String symbol) {
        return this.getSetAt(id, this.columnForSymbol(symbol));
    }

    public void appendValueAt(String directive, int id, String symbol) {
        this.appendValueAt(directive, id, this.columnForSymbol(symbol));
    }

    public int columnForSymbol(String symbol) {
        Integer in = (Integer)this.symbolsToColumn.get(symbol);
        if (in == null) {
            throw new IllegalArgumentException(String.valueOf(symbol) + " is not in the grammar!");
        }
        return in;
    }

    public int getRowCount() {
        return this.entries.length;
    }

    public int getColumnCount() {
        return this.entries[0].length;
    }

    private String parseValue(String value, int column) {
        if (column < 1) {
            return null;
        }
        if (value.equals("")) {
            return "";
        }
        if (column > this.terminals.length) {
            try {
                int i = Integer.parseInt(value);
                return Integer.toString(i);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        value = value.toLowerCase();
        switch (value.charAt(0)) {
            case 'a': {
                return "acc";
            }
            case 'r': 
            case 's': {
                if (value.length() < 2) {
                    return null;
                }
                int startDigits = 1;
                while (!Character.isDigit(value.charAt(startDigits))) {
                    ++startDigits;
                }
                try {
                    int i = Integer.parseInt(value.substring(startDigits));
                    return value.charAt(0) + Integer.toString(i);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private String[] parseValues(String input, int column) {
        StringTokenizer st = new StringTokenizer(input);
        TreeSet<String> values = new TreeSet<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = this.parseValue(token, column)) == null) continue;
            values.add(token);
        }
        return values.toArray(new String[0]);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return " ";
        }
        if (column > this.terminals.length) {
            return this.variables[column - 1 - this.terminals.length];
        }
        return this.terminals[column - 1];
    }

    public void setValueAt(Object value, int row, int column) {
        if (column == 0) {
            return;
        }
        String[] values = this.parseValues((String)value, column);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(values[i]);
            ++i;
        }
        this.entries[row][column] = sb.toString();
        this.fireTableCellUpdated(row, column);
    }

    public void appendValueAt(String directive, int row, int column) {
        this.setValueAt((Object)(this.getValueAt(row, column) + " " + directive), row, column);
    }

    public Object getValueAt(int row, int column) {
        return this.entries[row][column];
    }

    public SortedSet getSetAt(int row, int column) {
        StringTokenizer st = new StringTokenizer(this.entries[row][column]);
        TreeSet<String> set = new TreeSet<String>();
        while (st.hasMoreTokens()) {
            set.add(st.nextToken());
        }
        return set;
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    private String getContentDescription(String entry) {
        switch (entry.charAt(0)) {
            case 'a': {
                return "Accept";
            }
            case 's': {
                return "Shift current input and state " + entry.substring(1) + " to stack";
            }
            case 'r': {
                Production[] p = this.grammar.getProductions();
                int i = Integer.parseInt(entry.substring(1));
                String reduceDesc = "Reduce by production " + i + ", ";
                try {
                    reduceDesc = String.valueOf(reduceDesc) + p[i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    reduceDesc = String.valueOf(reduceDesc) + "which does not exist";
                }
                return reduceDesc;
            }
        }
        return "Goto state " + entry;
    }

    public String getContentDescription(int row, int column) {
        StringTokenizer st = new StringTokenizer(this.entries[row][column]);
        StringBuffer description = new StringBuffer();
        int n = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (n++ != 0) {
                description.append('\n');
            }
            description.append(this.getContentDescription(token));
        }
        if (description.length() == 0) {
            return "Reject";
        }
        return description.toString();
    }
}

