/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.parse.LRParseTable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class LRParseTableGenerator {
    public static LRParseTable generate(Grammar grammar, FiniteStateAutomaton gotoGraph, Map stateToItems, Map itemsToState, Map followSets) {
        LRParseTable pt = new LRParseTable(grammar, gotoGraph){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        Transition[] ts = gotoGraph.getTransitions();
        Production[] ps = grammar.getProductions();
        int i = 0;
        while (i < ts.length) {
            FSATransition t = (FSATransition)ts[i];
            if (grammar.isVariable(t.getLabel())) {
                pt.appendValueAt("" + t.getToState().getID(), t.getFromState().getID(), t.getLabel());
            } else {
                pt.appendValueAt("s" + t.getToState().getID(), t.getFromState().getID(), t.getLabel());
            }
            ++i;
        }
        State[] finals = gotoGraph.getFinalStates();
        int i2 = 0;
        while (i2 < finals.length) {
            Set items = (Set)stateToItems.get(finals[i2]);
            Iterator it = items.iterator();
            while (it.hasNext()) {
                Production p = (Production)it.next();
                if (p.getLHS().length() == 2) {
                    if (p.getRHS().length() != 2 || p.getRHS().charAt(1) != '\u00b7') continue;
                    pt.appendValueAt("acc", finals[i2].getID(), "$");
                    continue;
                }
                if (!p.getRHS().endsWith("\u00b7")) continue;
                Production p2 = new Production(p.getLHS(), p.getRHS().substring(0, p.getRHS().length() - 1));
                int j = 0;
                while (!p2.equals(ps[j])) {
                    ++j;
                }
                Set follow = (Set)followSets.get(p.getLHS());
                Iterator fit = follow.iterator();
                while (fit.hasNext()) {
                    String followSymbol = (String)fit.next();
                    pt.appendValueAt("r" + j, finals[i2].getID(), followSymbol);
                }
            }
            ++i2;
        }
        return pt;
    }
}

