/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.UnrestrictedGrammar;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Unrestricted {
    private Unrestricted() {
    }

    public static int minimumLength(String string, Set smaller) {
        int length = 0;
        int j = 0;
        while (j < string.length()) {
            if (!smaller.contains(string.substring(j, j + 1))) {
                ++length;
            }
            ++j;
        }
        return length;
    }

    private static int count(String s, char c) {
        int count = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static Set smallerSymbols(Grammar grammar) {
        boolean added;
        HashSet<String> smaller = new HashSet<String>();
        Production[] prods = grammar.getProductions();
        do {
            added = false;
            int i = 0;
            while (i < prods.length) {
                String left = prods[i].getLHS();
                String right = prods[i].getRHS();
                int rightLength = Unrestricted.minimumLength(right, smaller);
                int leftLength = Unrestricted.minimumLength(left, smaller);
                if (leftLength > rightLength) {
                    int j = 0;
                    while (j < left.length()) {
                        String symbol = left.substring(j, j + 1);
                        char s = symbol.charAt(0);
                        if (!smaller.contains(symbol) && Unrestricted.count(left, s) > Unrestricted.count(right, s)) {
                            smaller.add(symbol);
                            added = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } while (added);
        return smaller;
    }

    public static boolean isUnrestricted(Grammar grammar) {
        Production[] prods = grammar.getProductions();
        int i = 0;
        while (i < prods.length) {
            if (prods[i].getLHS().length() != 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static UnrestrictedGrammar optimize(Grammar grammar) {
        boolean changed;
        String startVariable = grammar.getStartVariable();
        Production[] prods = grammar.getProductions();
        HashSet<String> terminating = new HashSet<String>();
        boolean[] added = new boolean[prods.length];
        int i = 0;
        while (i < prods.length) {
            added[i] = false;
            if (prods[i].getVariablesOnRHS().length == 0) {
                terminating.addAll(Arrays.asList(prods[i].getSymbols()));
                added[i] = true;
            }
            ++i;
        }
        do {
            changed = false;
            int i2 = 0;
            while (i2 < prods.length) {
                List<String> l = Arrays.asList(prods[i2].getVariablesOnRHS());
                if (!added[i2] && terminating.containsAll(l)) {
                    terminating.addAll(Arrays.asList(prods[i2].getSymbols()));
                    changed = true;
                    added[i2] = true;
                }
                ++i2;
            }
        } while (changed);
        UnrestrictedGrammar g = new UnrestrictedGrammar();
        g.setStartVariable(grammar.getStartVariable());
        int i3 = 0;
        while (i3 < prods.length) {
            if (added[i3] && prods[i3].getLHS().equals(startVariable)) break;
            ++i3;
        }
        if (i3 == prods.length) {
            return null;
        }
        g.addProduction(prods[i3]);
        added[i3] = false;
        i3 = 0;
        while (i3 < prods.length) {
            if (added[i3]) {
                g.addProduction(prods[i3]);
            }
            ++i3;
        }
        return g;
    }
}

