/*
 * Decompiled with CFR 0.152.
 */
package grammar.reg;

import grammar.Grammar;
import grammar.Production;
import grammar.ProductionChecker;

public class RegularGrammar
extends Grammar {
    protected int myLinearity;
    protected static final int LEFT_LINEAR = 0;
    protected static final int RIGHT_LINEAR = 1;
    private static final ProductionChecker PC = new ProductionChecker();

    public RegularGrammar() {
        this.setLinearity(-1);
    }

    private void setLinearity(int linearity) {
        this.myLinearity = linearity;
    }

    private int getLinearity() {
        return this.myLinearity;
    }

    public void checkProduction(Production production) {
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            throw new IllegalArgumentException("The production is unrestricted on the left hand side.");
        }
        if (!ProductionChecker.isLeftLinear(production) && !ProductionChecker.isRightLinear(production)) {
            throw new IllegalArgumentException("The production is neither left nor right linear!");
        }
        if (this.getLinearity() != 0 && this.getLinearity() != 1) {
            return;
        }
        if (ProductionChecker.isLeftLinear(production) && ProductionChecker.isRightLinear(production)) {
            return;
        }
        if (this.getLinearity() == 0 && ProductionChecker.isRightLinear(production)) {
            throw new IllegalArgumentException("The production is right linear, the grammar is left linear.");
        }
        if (this.getLinearity() == 1 && ProductionChecker.isLeftLinear(production)) {
            throw new IllegalArgumentException("The production is left linear, the grammar is right linear.");
        }
    }

    public void addProduction(Production production) {
        super.addProduction(production);
        if (ProductionChecker.isRightLinear(production) && ProductionChecker.isLeftLinear(production)) {
            return;
        }
        this.setLinearity(ProductionChecker.isRightLinear(production) ? 1 : 0);
    }
}

