/*
 * Decompiled with CFR 0.152.
 */
package grammar.reg;

import automata.Automaton;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSATransition;
import grammar.Grammar;
import grammar.GrammarToAutomatonConverter;
import grammar.Production;
import grammar.ProductionChecker;
import java.awt.Point;

public class RightLinearGrammarToFSAConverter
extends GrammarToAutomatonConverter {
    protected String FINAL_STATE = "FINAL";

    public Transition getTransitionForProduction(Production production) {
        ProductionChecker pc = new ProductionChecker();
        String lhs = production.getLHS();
        State from = this.getStateForVariable(lhs);
        if (ProductionChecker.isRightLinearProductionWithVariable(production)) {
            String[] variables = production.getVariablesOnRHS();
            String variable = variables[0];
            State to = this.getStateForVariable(variable);
            String rhs = production.getRHS();
            String label = rhs.substring(0, rhs.length() - 1);
            FSATransition trans = new FSATransition(from, to, label);
            return trans;
        }
        if (ProductionChecker.isLinearProductionWithNoVariable(production)) {
            String transLabel = production.getRHS();
            State finalState = this.getStateForVariable(this.FINAL_STATE);
            FSATransition ftrans = new FSATransition(from, finalState, transLabel);
            return ftrans;
        }
        return null;
    }

    public void createStatesForConversion(Grammar grammar, Automaton automaton) {
        this.initialize();
        StatePlacer sp = new StatePlacer();
        String[] variables = grammar.getVariables();
        int k = 0;
        while (k < variables.length) {
            String variable = variables[k];
            Point point = sp.getPointForState(automaton);
            State state = automaton.createState(point);
            if (variable.equals(grammar.getStartVariable())) {
                automaton.setInitialState(state);
            }
            state.setLabel(variable);
            this.mapStateToVariable(state, variable);
            ++k;
        }
        Point pt = sp.getPointForState(automaton);
        State finalState = automaton.createState(pt);
        automaton.addFinalState(finalState);
        this.mapStateToVariable(finalState, this.FINAL_STATE);
    }
}

