/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class GrowableTableModel
extends AbstractTableModel
implements Cloneable {
    protected int columns;
    protected List data = new ArrayList();

    public GrowableTableModel(int columns) {
        this.columns = columns;
        this.clear();
    }

    public GrowableTableModel(GrowableTableModel model) {
        this.copy(model);
    }

    public void clear() {
        this.data.clear();
        this.data.add(this.initializeRow(0));
        this.fireTableDataChanged();
    }

    public void copy(GrowableTableModel model) {
        this.columns = model.getColumnCount();
        this.data.clear();
        Iterator it = model.data.iterator();
        while (it.hasNext()) {
            Object[] oldRow = (Object[])it.next();
            Object[] row = new Object[this.columns];
            int i = 0;
            while (i < oldRow.length) {
                row[i] = oldRow[i];
                ++i;
            }
            this.data.add(row);
        }
        this.fireTableDataChanged();
    }

    protected Object[] initializeRow(int row) {
        Object[] newRow = new Object[this.getColumnCount()];
        Arrays.fill(newRow, null);
        return newRow;
    }

    public final int getColumnCount() {
        return this.columns;
    }

    public final int getRowCount() {
        return this.data.size();
    }

    public boolean deleteRow(int row) {
        if (row < 0 || row > this.data.size() - 2) {
            return false;
        }
        this.data.remove(row);
        this.fireTableRowsDeleted(row, row);
        return true;
    }

    public void insertRow(Object[] newData, int row) {
        if (newData.length != this.columns) {
            throw new IllegalArgumentException("Data length is " + newData.length + ", should be " + this.columns + ".");
        }
        this.data.add(row, newData);
        this.fireTableRowsInserted(row, row);
    }

    public Object getValueAt(int row, int column) {
        return ((Object[])this.data.get(row))[column];
    }

    public void setValueAt(Object newData, int row, int column) {
        ((Object[])this.data.get((int)row))[column] = newData;
        if (row + 1 == this.getRowCount()) {
            this.data.add(this.initializeRow(row + 1));
            this.fireTableRowsInserted(row + 1, row + 1);
        }
        if (row >= this.getRowCount()) {
            this.data.add(this.initializeRow(row));
            this.fireTableRowsInserted(row, row);
        }
        this.fireTableCellUpdated(row, column);
    }
}

