/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class HighlightTable
extends JTable {
    private static TableHighlighterRendererGenerator THRG = new TableHighlighterRendererGenerator(){
        private DefaultTableCellRenderer renderer = null;

        public TableCellRenderer getRenderer(int row, int column) {
            if (this.renderer == null) {
                this.renderer = new DefaultTableCellRenderer();
                this.renderer.setBackground(new Color(255, 150, 150));
            }
            return this.renderer;
        }
    };
    private Map highlightRenderers = new HashMap();

    public HighlightTable() {
    }

    public HighlightTable(TableModel dm) {
        super(dm);
    }

    public void highlight(int row, int column) {
        this.highlight(row, column, THRG);
    }

    private static int singleIndex(int row, int column) {
        return row + (column << 22);
    }

    public void dehighlight(int row, int column) {
        this.highlightRenderers.remove(new Integer(HighlightTable.singleIndex(row, column)));
        this.repaint();
    }

    public void highlight(int[][] rc, TableHighlighterRendererGenerator generator) {
        this.highlightRenderers = new HashMap();
        int i = 0;
        while (i < rc.length) {
            this.highlight(rc[i][0], rc[i][1], generator);
            ++i;
        }
    }

    public void highlight(int row, int column, TableHighlighterRendererGenerator generator) {
        if (this.highlightRenderers == null) {
            this.highlightRenderers = new HashMap();
        }
        Integer in = new Integer(HighlightTable.singleIndex(row, column));
        this.highlightRenderers.put(in, generator.getRenderer(row, column));
        this.repaint();
    }

    public void dehighlight() {
        this.highlightRenderers = null;
        this.repaint();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer ren;
        int column2 = this.convertColumnIndexToModel(column);
        if (this.highlightRenderers != null && (ren = (TableCellRenderer)this.highlightRenderers.get(new Integer(HighlightTable.singleIndex(row, column2)))) != null) {
            return ren;
        }
        return super.getCellRenderer(row, column);
    }

    public static interface TableHighlighterRendererGenerator {
        public TableCellRenderer getRenderer(int var1, int var2);
    }
}

