/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ThrowableCatcher {
    private static final String ERROR_LOCATION = "/DOCS/error.html";

    public void handle(Throwable throwable) {
        String message = null;
        String report = null;
        try {
            InputStream is = this.getClass().getResource(ERROR_LOCATION).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuffer sb = new StringBuffer();
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                sb.append(nextLine);
            }
            message = sb.toString();
            StringWriter w = new StringWriter();
            PrintWriter writer = new PrintWriter(w);
            writer.println("PROPERTIES");
            System.getProperties().list(writer);
            writer.println("TRACE");
            throwable.printStackTrace(writer);
            writer.flush();
            w.flush();
            report = w.toString();
        }
        catch (Throwable e) {
            System.err.println("Could not display AWT error message.");
            throwable.printStackTrace();
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(message), "North");
        JTextArea area = new JTextArea(report);
        area.setEditable(false);
        panel.add((Component)new JScrollPane(area), "Center");
        panel.setPreferredSize(new Dimension(400, 400));
        JOptionPane.showMessageDialog(null, panel);
    }
}

