/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class WebFrame
extends JFrame {
    private JEditorPane myBrowserDisplay = new JEditorPane();
    private ArrayList myURLHistory = new ArrayList();
    private int myCurrentPosition = -1;
    private JButton myBackButton;
    private JButton myForwardButton;
    private JButton myStartButton;

    public WebFrame(String myHtmlFile) {
        this.setTitle("Help Browser");
        JPanel mainpanel = new JPanel(new BorderLayout());
        Hyperactive hyper = new Hyperactive();
        this.myBrowserDisplay.setEditable(false);
        this.myBrowserDisplay.addHyperlinkListener(hyper);
        JScrollPane htmlscrollpane = new JScrollPane(this.myBrowserDisplay);
        mainpanel.add((Component)htmlscrollpane, "Center");
        mainpanel.add((Component)this.getToolBar(), "North");
        String url = myHtmlFile;
        if (!myHtmlFile.startsWith("http://")) {
            URL u = this.getClass().getResource(myHtmlFile);
            url = u == null ? "" : u.toString();
        }
        this.setContentPane(mainpanel);
        this.pack();
        this.setSize(600, 700);
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(1);
        this.goNew(url);
    }

    public void gotoURL(String url) {
        if (!url.startsWith("http://")) {
            URL u = this.getClass().getResource(url);
            url = u == null ? "" : u.toString();
        }
        this.goNew(url);
    }

    private JToolBar getToolBar() {
        JToolBar toReturn = new JToolBar();
        toReturn.setFloatable(false);
        this.myBackButton = this.makeButton("Back", "left.gif", new BackAction(), null);
        this.myForwardButton = this.makeButton("Forward", "right.gif", new ForwardAction(), null);
        this.myStartButton = this.makeButton("Main Index", "start.gif", new HomeAction(), null);
        toReturn.add(this.myBackButton);
        toReturn.add(this.myForwardButton);
        toReturn.add(this.myStartButton);
        return toReturn;
    }

    private JButton makeButton(String label, String iconName, ActionListener listener, String tooltip) {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/ICON/web/" + iconName));
        JButton button = new JButton(label, icon);
        button.addActionListener(listener);
        button.setToolTipText(tooltip);
        return button;
    }

    private void goBack() {
        try {
            --this.myCurrentPosition;
            String url = (String)this.myURLHistory.get(this.myCurrentPosition);
            this.setDisplay(url);
        }
        catch (Throwable e) {
            ++this.myCurrentPosition;
        }
    }

    private void goHome() {
        int oldIndex = this.myCurrentPosition;
        try {
            this.myCurrentPosition = 0;
            String url = (String)this.myURLHistory.get(this.myCurrentPosition);
            this.setDisplay(url);
        }
        catch (Throwable e) {
            this.myCurrentPosition = oldIndex;
        }
    }

    private void goForward() {
        try {
            ++this.myCurrentPosition;
            String url = (String)this.myURLHistory.get(this.myCurrentPosition);
            this.setDisplay(url);
        }
        catch (Throwable e) {
            --this.myCurrentPosition;
        }
    }

    private void setDisplay(String url) {
        try {
            this.myBrowserDisplay.setPage(url);
        }
        catch (IOException e) {
            System.err.println(e);
            JOptionPane.showMessageDialog(this, "Could not access URL " + url + "!", "Web Error", 0);
            this.myURLHistory.remove(this.myCurrentPosition);
            --this.myCurrentPosition;
        }
        this.setEnabledStates();
    }

    private void setDisplay(URL url) {
        try {
            this.myBrowserDisplay.setPage(url);
        }
        catch (IOException e) {
            System.err.println(e);
            JOptionPane.showMessageDialog(this, "Could not access URL " + url + "!", "Web Error", 0);
            this.myURLHistory.remove(this.myCurrentPosition);
            --this.myCurrentPosition;
        }
        this.setEnabledStates();
    }

    private void goNew(String url) {
        ++this.myCurrentPosition;
        try {
            while (true) {
                String string = (String)this.myURLHistory.remove(this.myCurrentPosition);
            }
        }
        catch (Throwable throwable) {
            this.myURLHistory.add(url);
            this.setDisplay(url);
            return;
        }
    }

    private void setEnabledStates() {
        this.myBackButton.setEnabled(this.myCurrentPosition != 0);
        this.myStartButton.setEnabled(this.myCurrentPosition != 0);
        this.myForwardButton.setEnabled(this.myCurrentPosition != this.myURLHistory.size() - 1);
    }

    public class Hyperactive
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        WebFrame.this.goNew(e.getURL().toString());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    private class BackAction
    implements ActionListener {
        private BackAction() {
        }

        public void actionPerformed(ActionEvent e) {
            WebFrame.this.goBack();
        }
    }

    private class ForwardAction
    implements ActionListener {
        private ForwardAction() {
        }

        public void actionPerformed(ActionEvent e) {
            WebFrame.this.goForward();
        }
    }

    private class HomeAction
    implements ActionListener {
        private HomeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            WebFrame.this.goHome();
        }
    }
}

