/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;
import gui.action.SimulateAction;
import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.sim.SimulatorPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class BuildingBlockSimulateAction
extends SimulateAction {
    private Automaton automaton;
    private Environment environment = null;

    public BuildingBlockSimulateAction(Automaton automaton, Environment environment) {
        super(automaton, environment);
        this.putValue("Name", "Step by BuildingBlock");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, MAIN_MENU_MASK));
        this.automaton = automaton;
        this.environment = environment;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog((Component)e.getSource(), "Simulation requires an automaton\nwith an initial state!", "No Initial State", 0);
            return;
        }
        Object input = this.initialInput((Component)e.getSource(), "");
        if (input == null) {
            return;
        }
        Configuration[] configs = null;
        AutomatonSimulator simulator = this.getSimulator(this.automaton);
        if (this.getObject() instanceof TuringMachine) {
            String[] s = (String[])input;
            configs = ((TMSimulator)simulator).getInitialConfigurations(s);
        } else {
            String s = (String)input;
            configs = simulator.getInitialConfigurations(s);
        }
        this.handleInteraction(this.automaton, simulator, configs, input);
    }

    protected void handleInteraction(Automaton automaton, AutomatonSimulator simulator, Configuration[] configurations, Object initialInput) {
        SimulatorPane simpane = new SimulatorPane(automaton, simulator, configurations, this.environment, true);
        if (initialInput instanceof String[]) {
            initialInput = Arrays.asList((String[])initialInput);
        }
        this.environment.add((Component)simpane, "Simulate: " + initialInput, new CriticalTag(){});
        this.environment.setActive(simpane);
    }

    public static boolean isApplicable(Serializable object) {
        return object instanceof TuringMachine;
    }
}

