/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.State;
import gui.action.RestrictedAction;
import gui.editor.EditBlockPane;
import gui.editor.EditorPane;
import gui.environment.Environment;
import gui.environment.tag.PermanentTag;
import gui.environment.tag.Tag;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CloseAction
extends RestrictedAction {
    private Environment environment;

    public CloseAction(Environment environment) {
        super("Dismiss Tab", null);
        this.environment = environment;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, MAIN_MENU_MASK));
        environment.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CloseAction.this.checkEnabled();
            }
        });
        this.checkEnabled();
    }

    public void actionPerformed(ActionEvent e) {
        boolean editor = false;
        Automaton inside = null;
        State block = null;
        if (this.environment.getActive() instanceof EditBlockPane) {
            editor = true;
            EditBlockPane blockEditor = (EditBlockPane)this.environment.getActive();
            inside = blockEditor.getAutomaton();
            block = blockEditor.getBlock();
        }
        this.environment.remove(this.environment.getActive());
        if (editor) {
            EditorPane higherEditor = (EditorPane)this.environment.getActive();
            Automaton higher = higherEditor.getAutomaton();
            higher.replaceBlock(block, inside);
        }
    }

    private void checkEnabled() {
        Tag tag = this.environment.getTag(this.environment.getActive());
        if (this.environment.tabbed.getTabCount() == 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!(tag instanceof PermanentTag));
        }
    }
}

