/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.mealy.MooreMachine;
import automata.turing.TuringMachine;
import gui.action.AutomatonAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.viewer.AutomatonDrawer;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class CombineAutomaton
extends AutomatonAction {
    private AutomatonEnvironment environment;

    public CombineAutomaton(AutomatonEnvironment environment) {
        super("Combine Automata", null);
        this.environment = environment;
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox<EnvironmentFrame> combo = new JComboBox<EnvironmentFrame>();
        EnvironmentFrame[] frames = Universe.frames();
        int i = 0;
        while (i < frames.length) {
            block6: {
                block7: {
                    Environment env = frames[i].getEnvironment();
                    if (env == this.environment || !(env instanceof AutomatonEnvironment) || this.environment.getObject().getClass() != env.getObject().getClass()) break block6;
                    if (!(this.environment.getObject() instanceof TuringMachine)) break block7;
                    TuringMachine t1 = (TuringMachine)this.environment.getObject();
                    TuringMachine t2 = (TuringMachine)env.getObject();
                    if (t1.tapes() != t2.tapes()) break block6;
                }
                combo.addItem(frames[i]);
            }
            ++i;
        }
        if (combo.getItemCount() == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "No other automatons of this type around!");
            return;
        }
        int result = JOptionPane.showOptionDialog(Universe.frameForEnvironment(this.environment), combo, "Combine Two", 2, 3, null, null, null);
        if (result != 0 && result != 0) {
            return;
        }
        Automaton other = (Automaton)((EnvironmentFrame)combo.getSelectedItem()).getEnvironment().getObject();
        Automaton newOne = (Automaton)this.environment.getAutomaton().clone();
        this.add(newOne, other);
        FrameFactory.createFrame(newOne);
    }

    private void add(Automaton newOne, Automaton other) {
        AutomatonDrawer d1 = new AutomatonDrawer(newOne);
        AutomatonDrawer d2 = new AutomatonDrawer(other);
        Rectangle2D bounds1 = d1.getBounds();
        Rectangle2D bounds2 = d2.getBounds();
        if (bounds1 == null) {
            bounds1 = new Rectangle2D.Float();
        }
        if (bounds2 == null) {
            bounds2 = new Rectangle2D.Float();
        }
        double d = bounds1.getY() + bounds1.getHeight() - bounds2.getY() + 20.0;
        State[] otherStates = other.getStates();
        HashMap<State, State> otherToNew = new HashMap<State, State>();
        int i = 0;
        while (i < otherStates.length) {
            State s = otherStates[i];
            Point p = new Point(s.getPoint().x, s.getPoint().y + (int)d);
            State s2 = newOne.createState(p);
            if (other.isFinalState(s)) {
                newOne.addFinalState(s2);
            }
            s2.setLabel(s.getLabel());
            if (newOne instanceof MooreMachine && other instanceof MooreMachine) {
                MooreMachine m = (MooreMachine)newOne;
                MooreMachine n = (MooreMachine)other;
                m.setOutput(s2, n.getOutput(s));
            }
            otherToNew.put(s, s2);
            ++i;
        }
        Transition[] otherTransitions = other.getTransitions();
        int i2 = 0;
        while (i2 < otherTransitions.length) {
            Transition t = otherTransitions[i2];
            State from = (State)otherToNew.get(t.getFromState());
            State to = (State)otherToNew.get(t.getToState());
            newOne.addTransition(t.copy(from, to));
            ++i2;
        }
    }
}

