/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Transition;
import automata.graph.AutomatonGraph;
import automata.graph.GEMLayoutAlgorithm;
import automata.pda.PushdownAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.cfg.CFGToPDALRConverter;
import gui.action.GrammarAction;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.convert.ConvertPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class ConvertCFGLR
extends GrammarAction {
    private GrammarEnvironment environment;

    public ConvertCFGLR(GrammarEnvironment environment) {
        super("Convert CFG to PDA (LR)", null);
        this.environment = environment;
    }

    public void actionPerformed(ActionEvent e) {
        Grammar grammar = this.environment.getGrammar();
        if (grammar == null) {
            return;
        }
        if (grammar.getProductions().length == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The grammar should exist.");
            return;
        }
        PushdownAutomaton pda = new PushdownAutomaton();
        CFGToPDALRConverter convert = new CFGToPDALRConverter();
        convert.createStatesForConversion(grammar, pda);
        HashMap<Production, Transition> ptot = new HashMap<Production, Transition>();
        Production[] prods = grammar.getProductions();
        int i = 0;
        while (i < prods.length) {
            ptot.put(prods[i], convert.getTransitionForProduction(prods[i]));
            ++i;
        }
        ConvertPane cp = new ConvertPane(grammar, pda, ptot, this.environment);
        this.environment.add((Component)cp, "Convert to PDA (LR)", new CriticalTag(){});
        AutomatonGraph graph = new AutomatonGraph(pda);
        GEMLayoutAlgorithm layout = new GEMLayoutAlgorithm();
        layout.layout(graph, null);
        graph.moveAutomatonStates();
        this.environment.setActive(cp);
        this.environment.validate();
        cp.getEditorPane().getAutomatonPane().fitToBounds(20);
    }
}

