/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.pda.PDAToCFGConverter;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import gui.action.ConvertAutomatonToGrammarAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.PDAConvertController;
import gui.viewer.SelectionDrawer;
import gui.viewer.ZoomPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class ConvertPDAToGrammarAction
extends ConvertAutomatonToGrammarAction {
    private AutomatonEnvironment environment;
    private PushdownAutomaton automaton;
    private PDAToCFGConverter converter = new PDAToCFGConverter();

    public ConvertPDAToGrammarAction(AutomatonEnvironment environment) {
        super(environment);
    }

    protected boolean checkAutomaton() {
        EnvironmentFrame frame = Universe.frameForEnvironment(this.getEnvironment());
        JPanel messagePanel = new JPanel(new BorderLayout());
        SelectionDrawer drawer = new SelectionDrawer(this.getAutomaton());
        JLabel messageLabel = new JLabel();
        ZoomPane zoom = new ZoomPane(drawer);
        JPanel tempPanel = new JPanel(new BorderLayout());
        tempPanel.setBorder(new BevelBorder(1));
        zoom.setPreferredSize(new Dimension(300, 200));
        tempPanel.add((Component)zoom, "Center");
        messagePanel.add((Component)tempPanel, "Center");
        messagePanel.add((Component)messageLabel, "South");
        State[] finalStates = this.getAutomaton().getFinalStates();
        if (finalStates.length != 1) {
            JOptionPane.showMessageDialog(frame, "There must be exactly one final state!", "Final State Error", 0);
            return false;
        }
        Transition[] toFinal = this.getAutomaton().getTransitionsToState(finalStates[0]);
        HashSet<PDATransition> bad = new HashSet<PDATransition>();
        int i = 0;
        while (i < toFinal.length) {
            PDATransition t = (PDATransition)toFinal[i];
            if (!t.getStringToPop().equals("Z")) {
                bad.add(t);
            }
            ++i;
        }
        if (bad.size() != 0) {
            drawer.clearSelected();
            Iterator it = bad.iterator();
            while (it.hasNext()) {
                drawer.addSelected((Transition)it.next());
            }
            messageLabel.setText("Transitions to final must pop only 'Z'.");
            JOptionPane.showMessageDialog(frame, messagePanel, "Final Transitions Error", 0);
            return false;
        }
        Transition[] transitions = this.getAutomaton().getTransitions();
        bad.clear();
        int i2 = 0;
        while (i2 < transitions.length) {
            PDATransition t = (PDATransition)transitions[i2];
            if (t.getStringToPop().length() != 1 || t.getStringToPush().length() != 2 && t.getStringToPush().length() != 0) {
                bad.add(t);
            }
            ++i2;
        }
        if (bad.size() != 0) {
            drawer.clearSelected();
            Iterator it = bad.iterator();
            while (it.hasNext()) {
                drawer.addSelected((Transition)it.next());
            }
            messageLabel.setText("Transitions must pop 1 and push 0 or 2.");
            JOptionPane.showMessageDialog(frame, messagePanel, "Transitions Error", 0);
            return false;
        }
        return true;
    }

    public static boolean isApplicable(Object object) {
        return object instanceof PushdownAutomaton;
    }

    protected ConvertController initializeController(ConvertPane pane, SelectionDrawer drawer, Automaton automaton) {
        return new PDAConvertController(pane, drawer, (PushdownAutomaton)automaton);
    }
}

