/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Transition;
import automata.fsa.FiniteStateAutomaton;
import automata.graph.AutomatonGraph;
import automata.graph.GEMLayoutAlgorithm;
import grammar.Production;
import grammar.reg.RightLinearGrammar;
import grammar.reg.RightLinearGrammarToFSAConverter;
import gui.action.GrammarAction;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.convert.ConvertPane;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class ConvertRegularGrammarToFSA
extends GrammarAction {
    private GrammarEnvironment environment;
    static /* synthetic */ Class class$0;

    public ConvertRegularGrammarToFSA(GrammarEnvironment environment) {
        super("Convert Right-Linear Grammar to FA", null);
        this.environment = environment;
    }

    public void actionPerformed(ActionEvent e) {
        RightLinearGrammar grammar;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("grammar.reg.RightLinearGrammar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((grammar = (RightLinearGrammar)this.environment.getGrammar(clazz)) == null) {
            return;
        }
        if (grammar.getProductions().length == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The grammar should exist.");
            return;
        }
        FiniteStateAutomaton fsa = new FiniteStateAutomaton();
        RightLinearGrammarToFSAConverter convert = new RightLinearGrammarToFSAConverter();
        convert.createStatesForConversion(grammar, fsa);
        AutomatonGraph graph = new AutomatonGraph(fsa);
        HashMap<Production, Transition> ptot = new HashMap<Production, Transition>();
        Production[] prods = grammar.getProductions();
        int i = 0;
        while (i < prods.length) {
            Transition t = convert.getTransitionForProduction(prods[i]);
            graph.addEdge(t.getFromState(), t.getToState());
            ptot.put(prods[i], t);
            ++i;
        }
        ConvertPane cp = new ConvertPane(grammar, fsa, ptot, this.environment);
        this.environment.add((Component)cp, "Convert to FA", new CriticalTag(){});
        Rectangle r = cp.getEditorPane().getAutomatonPane().getVisibleRect();
        GEMLayoutAlgorithm layout = new GEMLayoutAlgorithm();
        layout.layout(graph, null);
        graph.moveAutomatonStates();
        this.environment.setActive(cp);
        this.environment.validate();
        cp.getEditorPane().getAutomatonPane().fitToBounds(20);
    }
}

