/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.UselessStatesDetector;
import automata.fsa.FiniteStateAutomaton;
import automata.graph.FSAEqualityChecker;
import gui.action.FSAAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class DFAEqualityAction
extends FSAAction {
    private Environment environment;
    private static FSAEqualityChecker checker = new FSAEqualityChecker();

    public DFAEqualityAction(FiniteStateAutomaton automaton, Environment environment) {
        super("Compare Equivalence", null);
        this.environment = environment;
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox<EnvironmentFrame> combo = new JComboBox<EnvironmentFrame>();
        EnvironmentFrame[] frames = Universe.frames();
        int i = 0;
        while (i < frames.length) {
            if (DFAEqualityAction.isApplicable(frames[i].getEnvironment().getObject()) && frames[i].getEnvironment() != this.environment) {
                combo.addItem(frames[i]);
            }
            ++i;
        }
        FiniteStateAutomaton automaton = (FiniteStateAutomaton)this.environment.getObject();
        if (combo.getItemCount() == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "No other FAs around!");
            return;
        }
        if (automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "This automaton has no initial state!");
            return;
        }
        int result = JOptionPane.showOptionDialog(Universe.frameForEnvironment(this.environment), combo, "Compare against FA", 2, 3, null, null, null);
        if (result != 0 && result != 0) {
            return;
        }
        FiniteStateAutomaton other = (FiniteStateAutomaton)((EnvironmentFrame)combo.getSelectedItem()).getEnvironment().getObject();
        if (other.getInitialState() == null) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The other automaton has no initial state!");
            return;
        }
        String checkedMessage = checker.equals(other = (FiniteStateAutomaton)UselessStatesDetector.cleanAutomaton(other), automaton = (FiniteStateAutomaton)UselessStatesDetector.cleanAutomaton(automaton)) ? "They ARE equivalent!" : "They AREN'T equivalent!";
        JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), checkedMessage);
    }
}

