/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.lsystem.LSystem;
import gui.action.LSystemAction;
import gui.environment.LSystemEnvironment;
import gui.environment.tag.CriticalTag;
import gui.lsystem.DisplayPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class LSystemDisplay
extends LSystemAction {
    public LSystemDisplay(LSystemEnvironment environment) {
        super(environment, "Render System", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, MAIN_MENU_MASK));
    }

    public void actionPerformed(ActionEvent e) {
        LSystem lsystem = this.getEnvironment().getLSystem();
        if (lsystem.getAxiom().size() == 0) {
            JOptionPane.showMessageDialog(this.getEnvironment(), "The axiom must have one or more symbols.", "Nonempty Axiom Required", 0);
            return;
        }
        try {
            DisplayPane pane = new DisplayPane(lsystem);
            this.getEnvironment().add((Component)pane, "L-S Render", new CriticalTag(){});
            this.getEnvironment().setActive(pane);
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(this.getEnvironment(), "Sorry, but this uses features requiring Java 1.4 or later!", "JVM too primitive", 0);
            return;
        }
    }
}

